/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.context;

import io.micrometer.context.ContextAccessor;
import io.micrometer.context.Nullable;
import io.micrometer.context.ThreadLocalAccessor;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ContextRegistry {
    private static final ContextRegistry instance = new ContextRegistry().loadContextAccessors().loadThreadLocalAccessors();
    private final List<ContextAccessor<?, ?>> contextAccessors = new CopyOnWriteArrayList();
    private final List<ThreadLocalAccessor<?>> threadLocalAccessors = new CopyOnWriteArrayList();
    private final List<ContextAccessor<?, ?>> readOnlyContextAccessors = Collections.unmodifiableList(this.contextAccessors);
    private final List<ThreadLocalAccessor<?>> readOnlyThreadLocalAccessors = Collections.unmodifiableList(this.threadLocalAccessors);

    public ContextRegistry registerContextAccessor(ContextAccessor<?, ?> accessor) {
        for (ContextAccessor<?, ?> existing : this.contextAccessors) {
            if (existing.readableType().isAssignableFrom(accessor.readableType()) || accessor.readableType().isAssignableFrom(existing.readableType())) {
                throw new IllegalArgumentException("Found an already registered accessor (" + existing.getClass().getCanonicalName() + ") reading " + existing.readableType().getCanonicalName() + " when trying to add accessor (" + accessor.getClass().getCanonicalName() + ") reading " + accessor.readableType().getCanonicalName());
            }
            if (!existing.writeableType().isAssignableFrom(accessor.writeableType()) && !accessor.writeableType().isAssignableFrom(existing.writeableType())) continue;
            throw new IllegalArgumentException("Found an already registered accessor (" + existing.getClass().getCanonicalName() + ") writing " + existing.writeableType().getCanonicalName() + " when trying to add accessor (" + accessor.getClass().getCanonicalName() + ") writing " + accessor.writeableType().getCanonicalName());
        }
        this.contextAccessors.add(accessor);
        return this;
    }

    public <V> ContextRegistry registerThreadLocalAccessor(String key, ThreadLocal<V> threadLocal) {
        return this.registerThreadLocalAccessor(key, threadLocal::get, threadLocal::set, threadLocal::remove);
    }

    public <V> ContextRegistry registerThreadLocalAccessor(final String key, final Supplier<V> getSupplier, final Consumer<V> setConsumer, final Runnable resetTask) {
        return this.registerThreadLocalAccessor(new ThreadLocalAccessor<V>(){

            @Override
            public Object key() {
                return key;
            }

            @Override
            @Nullable
            public V getValue() {
                return getSupplier.get();
            }

            @Override
            public void setValue(V value) {
                setConsumer.accept(value);
            }

            @Override
            public void setValue() {
                resetTask.run();
            }
        });
    }

    public ContextRegistry registerThreadLocalAccessor(ThreadLocalAccessor<?> accessor) {
        for (ThreadLocalAccessor<?> existing : this.threadLocalAccessors) {
            if (!existing.key().equals(accessor.key())) continue;
            this.threadLocalAccessors.remove(existing);
            break;
        }
        this.threadLocalAccessors.add(accessor);
        return this;
    }

    public boolean removeThreadLocalAccessor(String key) {
        return this.removeThreadLocalAccessor((Object)key);
    }

    public boolean removeThreadLocalAccessor(Object key) {
        for (ThreadLocalAccessor<?> existing : this.threadLocalAccessors) {
            if (!existing.key().equals(key)) continue;
            return this.threadLocalAccessors.remove(existing);
        }
        return false;
    }

    public boolean removeContextAccessor(ContextAccessor<?, ?> accessorToRemove) {
        return this.contextAccessors.remove(accessorToRemove);
    }

    public ContextRegistry loadContextAccessors() {
        ServiceLoader.load(ContextAccessor.class).forEach(this::registerContextAccessor);
        return this;
    }

    public ContextRegistry loadThreadLocalAccessors() {
        ServiceLoader.load(ThreadLocalAccessor.class).forEach(this::registerThreadLocalAccessor);
        return this;
    }

    public ContextAccessor<?, ?> getContextAccessorForRead(Object context) {
        for (ContextAccessor<?, ?> accessor : this.contextAccessors) {
            if (!accessor.readableType().isAssignableFrom(context.getClass())) continue;
            return accessor;
        }
        throw new IllegalStateException("No ContextAccessor for contextType: " + context.getClass());
    }

    public ContextAccessor<?, ?> getContextAccessorForWrite(Object context) {
        for (ContextAccessor<?, ?> accessor : this.contextAccessors) {
            if (!accessor.writeableType().isAssignableFrom(context.getClass())) continue;
            return accessor;
        }
        throw new IllegalStateException("No ContextAccessor for contextType: " + context.getClass());
    }

    public List<ContextAccessor<?, ?>> getContextAccessors() {
        return this.readOnlyContextAccessors;
    }

    public List<ThreadLocalAccessor<?>> getThreadLocalAccessors() {
        return this.readOnlyThreadLocalAccessors;
    }

    public String toString() {
        return "ContextRegistry{contextAccessors=" + this.contextAccessors + ", threadLocalAccessors=" + this.threadLocalAccessors + "}";
    }

    public static ContextRegistry getInstance() {
        return instance;
    }
}

