/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.context;

import io.micrometer.context.ContextAccessor;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.Nullable;
import io.micrometer.context.ThreadLocalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

final class DefaultContextSnapshot
extends HashMap<Object, Object>
implements ContextSnapshot {
    private static final ContextSnapshot emptyContextSnapshot = new DefaultContextSnapshot(new ContextRegistry());
    private final ContextRegistry contextRegistry;

    DefaultContextSnapshot(ContextRegistry contextRegistry) {
        this.contextRegistry = contextRegistry;
    }

    @Override
    public <C> C updateContext(C context) {
        return this.updateContextInternal(context, this);
    }

    @Override
    public <C> C updateContext(C context, Predicate<Object> keyPredicate) {
        if (!this.isEmpty()) {
            HashMap<Object, Object> valuesToWrite = new HashMap<Object, Object>();
            this.forEach((key, value) -> {
                if (keyPredicate.test(key)) {
                    valuesToWrite.put(key, value);
                }
            });
            context = this.updateContextInternal(context, valuesToWrite);
        }
        return context;
    }

    private <C> C updateContextInternal(C context, Map<Object, Object> valueContainer) {
        if (!this.isEmpty()) {
            ContextAccessor<?, ?> accessor = this.contextRegistry.getContextAccessorForWrite(context);
            context = accessor.writeValues(valueContainer, context);
        }
        return context;
    }

    @Override
    public ContextSnapshot.Scope setThreadLocals() {
        return this.setThreadLocals(key -> true);
    }

    @Override
    public ContextSnapshot.Scope setThreadLocals(Predicate<Object> keyPredicate) {
        Map<Object, Object> previousValues = null;
        for (ThreadLocalAccessor<?> accessor : this.contextRegistry.getThreadLocalAccessors()) {
            Object key = accessor.key();
            if (!keyPredicate.test(key)) continue;
            previousValues = DefaultContextSnapshot.setThreadLocal(key, this.get(key), accessor, previousValues);
        }
        return DefaultScope.from(previousValues, this.contextRegistry);
    }

    private static <V> Map<Object, Object> setThreadLocal(Object key, @Nullable V value, ThreadLocalAccessor<?> accessor, @Nullable Map<Object, Object> previousValues) {
        previousValues = previousValues != null ? previousValues : new HashMap<Object, Object>();
        previousValues.put(key, accessor.getValue());
        if (value != null) {
            accessor.setValue(value);
        } else {
            accessor.reset();
        }
        return previousValues;
    }

    static <C> ContextSnapshot.Scope setAllThreadLocalsFrom(Object context, ContextRegistry registry) {
        ContextAccessor<?, ?> contextAccessor = registry.getContextAccessorForRead(context);
        Map<Object, Object> previousValues = null;
        for (ThreadLocalAccessor<?> threadLocalAccessor : registry.getThreadLocalAccessors()) {
            Object key = threadLocalAccessor.key();
            Object value = contextAccessor.readValue(context, key);
            previousValues = DefaultContextSnapshot.setThreadLocal(key, value, threadLocalAccessor, previousValues);
        }
        return DefaultScope.from(previousValues, registry);
    }

    static <C> ContextSnapshot.Scope setThreadLocalsFrom(Object context, ContextRegistry registry, String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("You must provide at least one key when setting thread locals");
        }
        ContextAccessor<?, ?> contextAccessor = registry.getContextAccessorForRead(context);
        Map<Object, Object> previousValues = null;
        for (String key : keys) {
            Object value = contextAccessor.readValue(context, key);
            for (ThreadLocalAccessor<?> threadLocalAccessor : registry.getThreadLocalAccessors()) {
                if (!key.equals(threadLocalAccessor.key())) continue;
                previousValues = DefaultContextSnapshot.setThreadLocal(key, value, threadLocalAccessor, previousValues);
            }
        }
        return DefaultScope.from(previousValues, registry);
    }

    static ContextSnapshot captureAll(ContextRegistry contextRegistry, Predicate<Object> keyPredicate, Object ... contexts) {
        DefaultContextSnapshot snapshot = DefaultContextSnapshot.captureFromThreadLocals(keyPredicate, contextRegistry);
        for (Object context : contexts) {
            snapshot = DefaultContextSnapshot.captureFromContext(keyPredicate, contextRegistry, context, snapshot);
        }
        return snapshot != null ? snapshot : emptyContextSnapshot;
    }

    @Nullable
    private static DefaultContextSnapshot captureFromThreadLocals(Predicate<Object> keyPredicate, ContextRegistry contextRegistry) {
        DefaultContextSnapshot snapshot = null;
        for (ThreadLocalAccessor<?> accessor : contextRegistry.getThreadLocalAccessors()) {
            Object value;
            if (!keyPredicate.test(accessor.key()) || (value = accessor.getValue()) == null) continue;
            snapshot = snapshot != null ? snapshot : new DefaultContextSnapshot(contextRegistry);
            snapshot.put(accessor.key(), value);
        }
        return snapshot;
    }

    static DefaultContextSnapshot captureFromContext(Predicate<Object> keyPredicate, ContextRegistry contextRegistry, Object context, @Nullable DefaultContextSnapshot snapshot) {
        ContextAccessor<?, ?> accessor = contextRegistry.getContextAccessorForRead(context);
        snapshot = snapshot != null ? snapshot : new DefaultContextSnapshot(contextRegistry);
        accessor.readValues(context, keyPredicate, snapshot);
        return snapshot;
    }

    @Override
    public String toString() {
        return "DefaultContextSnapshot" + super.toString();
    }

    private static class DefaultScope
    implements ContextSnapshot.Scope {
        private final Map<Object, Object> previousValues;
        private final ContextRegistry contextRegistry;

        private DefaultScope(Map<Object, Object> previousValues, ContextRegistry contextRegistry) {
            this.previousValues = previousValues;
            this.contextRegistry = contextRegistry;
        }

        @Override
        public void close() {
            for (ThreadLocalAccessor<?> accessor : this.contextRegistry.getThreadLocalAccessors()) {
                if (!this.previousValues.containsKey(accessor.key())) continue;
                Object previousValue = this.previousValues.get(accessor.key());
                this.resetThreadLocalValue(accessor, previousValue);
            }
        }

        private <V> void resetThreadLocalValue(ThreadLocalAccessor<?> accessor, @Nullable V previousValue) {
            if (previousValue != null) {
                accessor.restore(previousValue);
            } else {
                accessor.reset();
            }
        }

        public static ContextSnapshot.Scope from(@Nullable Map<Object, Object> previousValues, ContextRegistry registry) {
            return previousValues != null ? new DefaultScope(previousValues, registry) : () -> {};
        }
    }
}

