/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watcher.hashing.HashCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PathUtils {
    public static HashCode hash(FileHasher fileHasher, Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return HashCode.empty();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return fileHasher.hash(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Map<WatchKey, Path> createKeyRootsMap() {
        return new ConcurrentHashMap<WatchKey, Path>();
    }

    public static Map<Path, HashCode> createHashCodeMap(Path path, FileHasher fileHasher) {
        return PathUtils.createHashCodeMap(Collections.singletonList(path), fileHasher);
    }

    public static Map<Path, HashCode> createHashCodeMap(List<Path> list, FileHasher fileHasher) {
        ConcurrentHashMap<Path, HashCode> concurrentHashMap = new ConcurrentHashMap<Path, HashCode>();
        if (fileHasher != null) {
            for (Path path : list) {
                for (Path path2 : PathUtils.recursiveListFiles(path)) {
                    HashCode hashCode = PathUtils.hash(fileHasher, path2);
                    if (hashCode == null) continue;
                    concurrentHashMap.put(path2, hashCode);
                }
            }
        }
        return concurrentHashMap;
    }

    public static Set<Path> recursiveListFiles(Path path) {
        File[] fileArray;
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        if (path.toFile().isDirectory() && (fileArray = path.toFile().listFiles()) != null) {
            for (File file : fileArray) {
                hashSet.addAll(PathUtils.recursiveListFiles(file.toPath()));
            }
        }
        return hashSet;
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }
}

