/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watchservice;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.methvin.watcher.PathUtils;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watchservice.AbstractWatchKey;
import io.methvin.watchservice.AbstractWatchService;
import io.methvin.watchservice.MacOSXWatchKey;
import io.methvin.watchservice.WatchablePath;
import io.methvin.watchservice.jna.CFArrayRef;
import io.methvin.watchservice.jna.CFIndex;
import io.methvin.watchservice.jna.CFRunLoopRef;
import io.methvin.watchservice.jna.CFStringRef;
import io.methvin.watchservice.jna.CarbonAPI;
import io.methvin.watchservice.jna.FSEventStreamRef;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;

public class MacOSXListeningWatchService
extends AbstractWatchService {
    private FileHasher INCREMENTING_FILE_HASHER = new FileHasher(){
        private final AtomicLong value = new AtomicLong();

        @Override
        public FileHash hash(Path path) throws IOException {
            return FileHash.fromLong(this.value.incrementAndGet());
        }
    };
    private final List<CarbonAPI.FSEventStreamCallback> callbackList = new ArrayList<CarbonAPI.FSEventStreamCallback>();
    private final List<CFRunLoopThread> threadList = new ArrayList<CFRunLoopThread>();
    private final Set<Path> pathsWatching = new HashSet<Path>();
    private final double latency;
    private final int queueSize;
    private final FileHasher fileHasher;
    private final boolean fileLevelEvents;
    private final long kFSEventStreamEventIdSinceNow = -1L;
    private final int kFSEventStreamCreateFlagNoDefer = 2;
    private final int kFSEventStreamCreateFlagFileEvents = 16;

    public MacOSXListeningWatchService(Config config) {
        this.latency = config.latency();
        this.queueSize = config.queueSize();
        FileHasher fileHasher = config.fileHasher();
        this.fileLevelEvents = fileHasher == null || config.fileLevelEvents();
        this.fileHasher = fileHasher == null ? this.INCREMENTING_FILE_HASHER : fileHasher;
    }

    public MacOSXListeningWatchService() {
        this(new Config(){});
    }

    @Override
    public synchronized AbstractWatchKey register(WatchablePath watchablePath, Iterable<? extends WatchEvent.Kind<?>> iterable) throws IOException {
        this.checkOpen();
        MacOSXWatchKey macOSXWatchKey = new MacOSXWatchKey((AbstractWatchService)this, watchablePath, iterable, this.queueSize);
        Path path = watchablePath.getFile().toAbsolutePath();
        for (Path pointerArray2 : this.pathsWatching) {
            if (!path.startsWith(pointerArray2)) continue;
            return macOSXWatchKey;
        }
        SortedMap<Path, FileHash> sortedMap = PathUtils.createHashCodeMap(path, this.fileHasher);
        Pointer[] pointerArray = new Pointer[]{CFStringRef.toCFString(path.toString()).getPointer()};
        CFArrayRef cFArrayRef = CarbonAPI.INSTANCE.CFArrayCreate(null, pointerArray, CFIndex.valueOf(1), null);
        MacOSXListeningCallback macOSXListeningCallback = new MacOSXListeningCallback(macOSXWatchKey, this.fileHasher, sortedMap, path);
        this.callbackList.add(macOSXListeningCallback);
        int n = 2;
        if (this.fileLevelEvents) {
            n |= 0x10;
        }
        FSEventStreamRef fSEventStreamRef = CarbonAPI.INSTANCE.FSEventStreamCreate(Pointer.NULL, macOSXListeningCallback, Pointer.NULL, cFArrayRef, -1L, this.latency, n);
        CFRunLoopThread cFRunLoopThread = new CFRunLoopThread(fSEventStreamRef, path.toFile());
        macOSXListeningCallback.onClose(() -> this.close(cFRunLoopThread, macOSXListeningCallback, path));
        cFRunLoopThread.setDaemon(true);
        cFRunLoopThread.start();
        this.threadList.add(cFRunLoopThread);
        this.pathsWatching.add(path);
        return macOSXWatchKey;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.threadList.forEach(CFRunLoopThread::close);
        this.threadList.clear();
        this.callbackList.clear();
        this.pathsWatching.clear();
    }

    public synchronized void close(CFRunLoopThread cFRunLoopThread, CarbonAPI.FSEventStreamCallback fSEventStreamCallback, Path path) {
        this.threadList.remove(cFRunLoopThread);
        this.callbackList.remove(fSEventStreamCallback);
        this.pathsWatching.remove(path);
        cFRunLoopThread.close();
    }

    public static interface Config {
        public static final double DEFAULT_LATENCY = 0.5;
        public static final int DEFAULT_QUEUE_SIZE = 1024;

        default public double latency() {
            return 0.5;
        }

        default public int queueSize() {
            return 1024;
        }

        default public boolean fileLevelEvents() {
            return false;
        }

        default public FileHasher fileHasher() {
            return FileHasher.DEFAULT_FILE_HASHER;
        }
    }

    private static class MacOSXListeningCallback
    implements CarbonAPI.FSEventStreamCallback {
        private final MacOSXWatchKey watchKey;
        private final SortedMap<Path, FileHash> hashCodeMap;
        private final FileHasher fileHasher;
        private final Path realPath;
        private final Path absPath;
        private final int realPathSize;
        private Runnable onCloseCallback;

        private MacOSXListeningCallback(MacOSXWatchKey macOSXWatchKey, FileHasher fileHasher, SortedMap<Path, FileHash> sortedMap, Path path) throws IOException {
            this.watchKey = macOSXWatchKey;
            this.hashCodeMap = sortedMap;
            this.fileHasher = fileHasher;
            this.realPath = path.toRealPath(new LinkOption[0]);
            this.absPath = path;
            this.realPathSize = this.realPath.toString().length() + 1;
        }

        public void onClose(Runnable runnable) {
            this.onCloseCallback = runnable;
        }

        @Override
        public void invoke(FSEventStreamRef fSEventStreamRef, Pointer pointer, NativeLong nativeLong, Pointer pointer2, Pointer pointer3, Pointer pointer4) {
            int n = nativeLong.intValue();
            for (String string : pointer2.getStringArray(0L, n)) {
                Set<Path> set;
                Path path = string.length() + 1 != this.realPathSize ? this.absPath.resolve(string.substring(this.realPathSize)) : this.absPath;
                try {
                    set = PathUtils.recursiveListFiles(path);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Could not recursively list files for " + path, iOException);
                }
                for (Path path2 : this.findCreatedFiles(set)) {
                    if (!this.watchKey.isReportCreateEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, path2);
                }
                for (Path path3 : this.findModifiedFiles(set)) {
                    if (!this.watchKey.isReportModifyEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, path3);
                }
                List<Path> list = this.findDeletedFiles(path, set);
                if (this.hashCodeMap.isEmpty()) {
                    this.watchKey.cancel();
                }
                Iterator object2 = list.iterator();
                while (object2.hasNext()) {
                    Path path4 = (Path)object2.next();
                    if (!this.watchKey.isReportDeleteEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, path4);
                }
                if (!this.hashCodeMap.isEmpty()) continue;
                try {
                    this.onCloseCallback.run();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        private List<Path> findModifiedFiles(Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : set) {
                FileHash fileHash = (FileHash)this.hashCodeMap.get(path);
                FileHash fileHash2 = PathUtils.hash(this.fileHasher, path);
                if (fileHash2 == null || fileHash2.equals(fileHash)) continue;
                arrayList.add(path);
                this.hashCodeMap.put(path, fileHash2);
            }
            return arrayList;
        }

        private List<Path> findCreatedFiles(Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : set) {
                FileHash fileHash;
                if (this.hashCodeMap.containsKey(path) || (fileHash = PathUtils.hash(this.fileHasher, path)) == null) continue;
                arrayList.add(path);
                this.hashCodeMap.put(path, fileHash);
            }
            return arrayList;
        }

        private List<Path> findDeletedFiles(Path path, Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            Set<Path> set2 = PathUtils.subMap(this.hashCodeMap, path).keySet();
            for (Path path2 : set2) {
                if (!path2.startsWith(path) || set.contains(path2)) continue;
                arrayList.add(path2);
                set2.remove(path2);
            }
            return arrayList;
        }
    }

    public static class CFRunLoopThread
    extends Thread {
        private final FSEventStreamRef streamRef;
        private CFRunLoopRef runLoopRef;
        private boolean isClosed = false;

        public CFRunLoopThread(FSEventStreamRef fSEventStreamRef, File file) {
            super("WatchService for " + file);
            this.streamRef = fSEventStreamRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSEventStreamRef fSEventStreamRef = this.streamRef;
            synchronized (fSEventStreamRef) {
                if (this.isClosed) {
                    return;
                }
                this.runLoopRef = CarbonAPI.INSTANCE.CFRunLoopGetCurrent();
                CFStringRef cFStringRef = CFStringRef.toCFString("kCFRunLoopDefaultMode");
                CarbonAPI.INSTANCE.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoopRef, cFStringRef);
                CarbonAPI.INSTANCE.FSEventStreamStart(this.streamRef);
            }
            CarbonAPI.INSTANCE.CFRunLoopRun();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            FSEventStreamRef fSEventStreamRef = this.streamRef;
            synchronized (fSEventStreamRef) {
                if (this.isClosed) {
                    return;
                }
                if (this.runLoopRef != null) {
                    CarbonAPI.INSTANCE.CFRunLoopStop(this.runLoopRef);
                    CarbonAPI.INSTANCE.FSEventStreamStop(this.streamRef);
                    CarbonAPI.INSTANCE.FSEventStreamInvalidate(this.streamRef);
                }
                CarbonAPI.INSTANCE.FSEventStreamRelease(this.streamRef);
                this.isClosed = true;
            }
        }
    }
}

