/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen;

import io.mateo.cxf.codegen.dsl.CxfCodegenExtension;
import io.mateo.cxf.codegen.wsdl2java.Wsdl2Java;
import io.mateo.cxf.codegen.wsdl2java.Wsdl2JavaOptions;
import io.mateo.cxf.codegen.wsdl2js.Wsdl2Js;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.util.GradleVersion;

public class CxfCodegenPlugin
implements Plugin<Project> {
    private static final String WSDL2JAVA_TOOL_MAIN_CLASS = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    private static final String WSDL2JS_TOOL_MAIN_CLASS = "org.apache.cxf.tools.wsdlto.javascript.WSDLToJavaScript";
    public static final String CXF_CODEGEN_CONFIGURATION_NAME = "cxfCodegen";
    public static final String WSDL2JAVA_TASK_NAME = "wsdl2java";
    public static final String WSDL2JAVA_GROUP = "wsdl2java";
    public static final String WSDL2JS_TASK_NAME = "wsdl2js";
    public static final String WSDL2JS_GROUP = "wsdl2js";

    public void apply(Project project) {
        CxfCodegenExtension extension = this.createExtension(project);
        NamedDomainObjectProvider<Configuration> cxfCodegenConfiguration = this.createConfiguration(project, extension);
        this.configureWsdl2JavaTaskConventions(project, cxfCodegenConfiguration);
        this.configureWsdl2JsTaskConventions(project, cxfCodegenConfiguration);
        this.addToSourceSet(project);
        this.registerAggregateTask(project);
    }

    private CxfCodegenExtension createExtension(Project project) {
        CxfCodegenExtension extension = (CxfCodegenExtension)project.getExtensions().create(CXF_CODEGEN_CONFIGURATION_NAME, CxfCodegenExtension.class, new Object[0]);
        extension.getCxfVersion().convention((Object)"3.5.5");
        return extension;
    }

    private void configureWsdl2JsTaskConventions(Project project, NamedDomainObjectProvider<Configuration> cxfCodegenConfiguration) {
        project.getTasks().withType(Wsdl2Js.class).configureEach(task -> {
            this.configureMainClass((JavaExec)task, WSDL2JS_TOOL_MAIN_CLASS);
            task.setClasspath((FileCollection)cxfCodegenConfiguration.get());
            task.setGroup("wsdl2js");
            task.setDescription("Generates JavaScript sources for '" + task.getName() + "'");
        });
    }

    private void configureWsdl2JavaTaskConventions(Project project, NamedDomainObjectProvider<Configuration> cxfCodegenConfiguration) {
        project.getTasks().withType(Wsdl2Java.class).configureEach(task -> {
            this.configureMainClass((JavaExec)task, WSDL2JAVA_TOOL_MAIN_CLASS);
            this.configureOnlyIf((Wsdl2Java)((Object)task));
            task.setClasspath((FileCollection)cxfCodegenConfiguration.get());
            task.setGroup("wsdl2java");
            task.setDescription("Generates Java sources for '" + task.getName() + "'");
        });
    }

    private void configureMainClass(JavaExec javaExec, String mainClass) {
        try {
            javaExec.getMainClass().set((Object)mainClass);
        }
        catch (NoSuchMethodError ignored) {
            javaExec.setMain(mainClass);
        }
    }

    private void configureOnlyIf(Wsdl2Java wsdl2Java) {
        try {
            wsdl2Java.onlyIf("run only if 'wsdl' or 'wsdlUrl' is set", self -> {
                Wsdl2JavaOptions options = ((Wsdl2Java)((Object)self)).getWsdl2JavaOptions();
                return options.getWsdl().isPresent() || options.getWsdlUrl().isPresent();
            });
        }
        catch (NoSuchMethodError ignored) {
            wsdl2Java.onlyIf(task -> {
                boolean shouldExecute;
                Wsdl2JavaOptions options = ((Wsdl2Java)((Object)task)).getWsdl2JavaOptions();
                boolean bl = shouldExecute = options.getWsdl().isPresent() || options.getWsdlUrl().isPresent();
                if (!shouldExecute && task.getLogger().isInfoEnabled()) {
                    task.getLogger().info("run only if 'wsdl' or 'wsdlUrl' is set");
                }
                return shouldExecute;
            });
        }
    }

    private void registerAggregateTask(Project project) {
        TaskCollection wsdl2Javas = project.getTasks().withType(Wsdl2Java.class);
        project.getTasks().register("wsdl2java", task -> {
            task.dependsOn(new Object[]{wsdl2Javas});
            task.setGroup("wsdl2java");
            task.setDescription("Runs all wsdl2java tasks");
        });
        TaskCollection wsdl2JsTasks = project.getTasks().withType(Wsdl2Js.class);
        project.getTasks().register("wsdl2js", task -> {
            task.dependsOn(new Object[]{wsdl2JsTasks});
            task.setGroup("wsdl2js");
            task.setDescription("Runs all wsdl2js tasks");
        });
    }

    private void addToSourceSet(Project project) {
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(Wsdl2Java.class).all(wsdl2Java -> {
            if (((Boolean)wsdl2Java.getAddToMainSourceSet().get()).booleanValue()) {
                evaluated.getExtensions().configure(SourceSetContainer.class, sourceSets -> sourceSets.named("main", main -> main.getJava().srcDir((Object)wsdl2Java.getWsdl2JavaOptions().getOutputDir())));
            }
        }));
    }

    private NamedDomainObjectProvider<Configuration> createConfiguration(Project project, CxfCodegenExtension extension) {
        return project.getConfigurations().register(CXF_CODEGEN_CONFIGURATION_NAME, configuration -> {
            configuration.setVisible(false);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            configuration.setDescription("Classpath for CXF Codegen.");
            this.setDependenciesCompatibility(project, (Configuration)configuration, extension);
        });
    }

    private void setDependenciesCompatibility(Project project, Configuration configuration, CxfCodegenExtension extension) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.0")) < 0) {
            configuration.getDependencies().addAll(this.createDependenciesCompatibility(project, extension));
        } else {
            configuration.getDependencies().addAllLater(this.createDependencies(project, extension));
        }
    }

    private Provider<List<Dependency>> createDependencies(Project project, CxfCodegenExtension extension) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.4")) < 0) {
            String cxfVersion2 = (String)extension.getCxfVersion().get();
            return this.createDependenciesProvider(project, cxfVersion2);
        }
        return extension.getCxfVersion().flatMap(cxfVersion -> this.createDependenciesProvider(project, (String)cxfVersion));
    }

    private ListProperty<Dependency> createDependenciesProvider(Project project, String cxfVersion) {
        ListProperty dependencies = project.getObjects().listProperty(Dependency.class);
        this.addDependencies(arg_0 -> ((ListProperty)dependencies).add(arg_0), project.getDependencies(), cxfVersion);
        return dependencies;
    }

    private List<Dependency> createDependenciesCompatibility(Project project, CxfCodegenExtension extension) {
        String cxfVersion = (String)extension.getCxfVersion().get();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        this.addDependencies(dependencies::add, project.getDependencies(), cxfVersion);
        return dependencies;
    }

    private void addDependencies(Consumer<Dependency> adderFn, DependencyHandler dependencyHandler, String cxfVersion) {
        adderFn.accept(dependencyHandler.create((Object)("org.apache.cxf:cxf-core:" + cxfVersion)));
        adderFn.accept(dependencyHandler.create((Object)("org.apache.cxf:cxf-tools-common:" + cxfVersion)));
        adderFn.accept(dependencyHandler.create((Object)("org.apache.cxf:cxf-tools-wsdlto-core:" + cxfVersion)));
        adderFn.accept(dependencyHandler.create((Object)("org.apache.cxf:cxf-tools-wsdlto-databinding-jaxb:" + cxfVersion)));
        adderFn.accept(dependencyHandler.create((Object)("org.apache.cxf:cxf-tools-wsdlto-frontend-jaxws:" + cxfVersion)));
        ModuleDependency dependency = (ModuleDependency)dependencyHandler.create((Object)("org.apache.cxf:cxf-tools-wsdlto-frontend-javascript:" + cxfVersion));
        HashMap<String, String> excludeProperties = new HashMap<String, String>();
        excludeProperties.put("group", "org.apache.cxf");
        excludeProperties.put("module", "cxf-rt-frontend-simple");
        dependency.exclude(excludeProperties);
        adderFn.accept((Dependency)dependency);
    }
}

