/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen.wsdl2js;

import java.util.Objects;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class Wsdl2JsOptions {
    private final Property<String> wsdl;
    private final Property<String> wsdlVersion;
    private final ListProperty<UriPrefixPair> packagePrefixes;
    private final RegularFileProperty catalog;
    private final Property<String> validate;
    private final Property<Boolean> verbose;
    private final Property<Boolean> quiet;
    private final DirectoryProperty outputDir;

    @Inject
    public Wsdl2JsOptions(String taskName, ObjectFactory objects, ProjectLayout layout) {
        this.wsdl = objects.property(String.class);
        this.wsdlVersion = objects.property(String.class);
        this.packagePrefixes = objects.listProperty(UriPrefixPair.class);
        this.catalog = objects.fileProperty();
        this.validate = objects.property(String.class);
        this.verbose = objects.property(Boolean.class);
        this.quiet = objects.property(Boolean.class);
        this.outputDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir(taskName + "-wsdl2js-generated-sources"));
    }

    @Input
    public Property<String> getWsdl() {
        return this.wsdl;
    }

    @Input
    @Optional
    public Property<String> getWsdlVersion() {
        return this.wsdlVersion;
    }

    @Input
    @Optional
    public ListProperty<UriPrefixPair> getPackagePrefixes() {
        return this.packagePrefixes;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public RegularFileProperty getCatalog() {
        return this.catalog;
    }

    @Input
    @Optional
    public Property<String> getValidate() {
        return this.validate;
    }

    @Input
    @Optional
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @Input
    @Optional
    public Property<Boolean> getQuiet() {
        return this.quiet;
    }

    @OutputDirectory
    @Optional
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public static class UriPrefixPair {
        private String uri;
        private String prefix;

        public UriPrefixPair() {
        }

        public UriPrefixPair(String uri, String prefix) {
            this.uri = Objects.requireNonNull(uri, "'uri' must not be null for UriPrefixPair");
            this.prefix = Objects.requireNonNull(prefix, "'prefix' must not be null for UriPrefixPair");
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = Objects.requireNonNull(uri, "'uri' must not be null for UriPrefixPair");
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "'prefix' must not be null for UriPrefixPair");
        }

        public String toString() {
            return new StringJoiner(", ", UriPrefixPair.class.getSimpleName() + "[", "]").add("uri='" + this.uri + "'").add("prefix='" + this.prefix + "'").toString();
        }
    }
}

