/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen.wsdl2js;

import io.mateo.cxf.codegen.wsdl2js.Wsdl2JsOptions;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;

@CacheableTask
public abstract class Wsdl2Js
extends JavaExec {
    private final Wsdl2JsOptions wsdl2JsOptions = (Wsdl2JsOptions)this.getProject().getObjects().newInstance(Wsdl2JsOptions.class, new Object[]{this.getName()});

    public Wsdl2Js() {
        this.getArgumentProviders().add(new Wsdl2JsArgumentProvider());
    }

    @Nested
    public Wsdl2JsOptions getWsdl2JsOptions() {
        return this.wsdl2JsOptions;
    }

    public void toolOptions(Action<? super Wsdl2JsOptions> configurer) {
        configurer.execute((Object)this.wsdl2JsOptions);
    }

    private class Wsdl2JsArgumentProvider
    implements CommandLineArgumentProvider {
        private Wsdl2JsArgumentProvider() {
        }

        public Iterable<String> asArguments() {
            ArrayList<String> arguments = new ArrayList<String>();
            Wsdl2JsOptions options = Wsdl2Js.this.getWsdl2JsOptions();
            if (options.getWsdlVersion().isPresent()) {
                arguments.add("-wv");
                arguments.add((String)options.getWsdlVersion().get());
            }
            if (options.getPackagePrefixes().isPresent()) {
                for (Wsdl2JsOptions.UriPrefixPair uriPrefixPair : (List)options.getPackagePrefixes().get()) {
                    arguments.add("-p");
                    arguments.add(String.format("%s=%s", uriPrefixPair.getPrefix(), uriPrefixPair.getUri()));
                }
            }
            if (options.getCatalog().isPresent()) {
                arguments.add("-catalog");
                arguments.add((String)options.getCatalog().map(it -> it.getAsFile().toPath().toAbsolutePath().toString()).get());
            }
            arguments.add("-d");
            arguments.add(((Directory)options.getOutputDir().get()).getAsFile().getAbsolutePath());
            if (options.getValidate().isPresent()) {
                arguments.add("-validate=" + (String)options.getValidate().get());
            }
            if (options.getVerbose().isPresent() && options.getQuiet().isPresent()) {
                throw new GradleException("Verbose and quite are mutually exclusive; only one can be enabled, not both.");
            }
            if (options.getVerbose().isPresent() && ((Boolean)options.getVerbose().get()).booleanValue()) {
                arguments.add("-verbose");
            }
            if (options.getQuiet().isPresent() && ((Boolean)options.getQuiet().get()).booleanValue()) {
                arguments.add("-quiet");
            }
            arguments.add((String)options.getWsdl().get());
            return arguments;
        }
    }
}

