/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen.wsdl2java;

import io.mateo.cxf.codegen.wsdl2java.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

@Deprecated
public class WsdlOption
implements Option,
Named {
    private final String name;
    private final RegularFileProperty wsdl;
    private final ListProperty<String> packageNames;
    private final ListProperty<String> extraArgs;
    private final ListProperty<String> xjcArgs;
    private final ListProperty<String> asyncMethods;
    private final ListProperty<String> bareMethods;
    private final ListProperty<String> mimeMethods;
    private final ListProperty<String> namespaceExcludes;
    private final Property<Boolean> defaultExcludesNamespace;
    private final Property<Boolean> defaultNamespacePackageMapping;
    private final SetProperty<String> bindingFiles;
    private final Property<String> wsdlLocation;
    private final Property<Boolean> wsdlList;
    private final Property<String> frontend;
    private final Property<String> databinding;
    private final Property<String> wsdlVersion;
    private final Property<String> catalog;
    private final Property<Boolean> extendedSoapHeaders;
    private final Property<String> validateWsdl;
    private final Property<Boolean> noTypes;
    private final Property<String> faultSerialVersionUid;
    private final Property<String> exceptionSuper;
    private final ListProperty<String> seiSuper;
    private final Property<Boolean> markGenerated;
    private final Property<Boolean> suppressGeneratedDate;
    private final Property<String> serviceName;
    private final Property<Boolean> autoNameResolution;
    private final Property<Boolean> noAddressBinding;
    private final Property<Boolean> allowElementRefs;
    private final Property<String> encoding;
    private final Property<Boolean> verbose;
    private final DirectoryProperty outputDir;
    private final ProjectLayout layout;

    @Inject
    public WsdlOption(String name, ObjectFactory objects, ProjectLayout layout) {
        this.name = name;
        this.layout = layout;
        this.outputDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated-sources/cxf/" + name));
        this.wsdl = objects.fileProperty();
        this.packageNames = objects.listProperty(String.class);
        this.extraArgs = objects.listProperty(String.class);
        this.xjcArgs = objects.listProperty(String.class);
        this.asyncMethods = objects.listProperty(String.class);
        this.bareMethods = objects.listProperty(String.class);
        this.mimeMethods = objects.listProperty(String.class);
        this.namespaceExcludes = objects.listProperty(String.class);
        this.defaultExcludesNamespace = objects.property(Boolean.class);
        this.defaultNamespacePackageMapping = objects.property(Boolean.class);
        this.bindingFiles = objects.setProperty(String.class);
        this.wsdlLocation = objects.property(String.class);
        this.wsdlList = objects.property(Boolean.class);
        this.frontend = objects.property(String.class);
        this.databinding = objects.property(String.class);
        this.wsdlVersion = objects.property(String.class);
        this.catalog = objects.property(String.class);
        this.extendedSoapHeaders = objects.property(Boolean.class);
        this.validateWsdl = objects.property(String.class);
        this.noTypes = objects.property(Boolean.class);
        this.faultSerialVersionUid = objects.property(String.class);
        this.exceptionSuper = objects.property(String.class);
        this.seiSuper = objects.listProperty(String.class);
        this.markGenerated = objects.property(Boolean.class);
        this.suppressGeneratedDate = objects.property(Boolean.class);
        this.serviceName = objects.property(String.class);
        this.autoNameResolution = objects.property(Boolean.class);
        this.noAddressBinding = objects.property(Boolean.class);
        this.allowElementRefs = objects.property(Boolean.class);
        this.encoding = objects.property(String.class);
        this.verbose = objects.property(Boolean.class);
    }

    @Override
    public RegularFileProperty getWsdl() {
        return this.wsdl;
    }

    @Override
    public ListProperty<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public ListProperty<String> getExtraArgs() {
        return this.extraArgs;
    }

    @Override
    public ListProperty<String> getXjcArgs() {
        return this.xjcArgs;
    }

    @Override
    public ListProperty<String> getAsyncMethods() {
        return this.asyncMethods;
    }

    @Override
    public ListProperty<String> getBareMethods() {
        return this.bareMethods;
    }

    @Override
    public ListProperty<String> getMimeMethods() {
        return this.mimeMethods;
    }

    @Override
    public ListProperty<String> getNamespaceExcludes() {
        return this.namespaceExcludes;
    }

    @Override
    public Property<Boolean> getDefaultExcludesNamespace() {
        return this.defaultExcludesNamespace;
    }

    @Override
    public Property<Boolean> getDefaultNamespacePackageMapping() {
        return this.defaultNamespacePackageMapping;
    }

    @Override
    public SetProperty<String> getBindingFiles() {
        return this.bindingFiles;
    }

    @Override
    public Property<String> getWsdlLocation() {
        return this.wsdlLocation;
    }

    @Override
    public Property<Boolean> getWsdlList() {
        return this.wsdlList;
    }

    @Override
    public Property<String> getFrontend() {
        return this.frontend;
    }

    @Override
    public Property<String> getDatabinding() {
        return this.databinding;
    }

    @Override
    public Property<String> getWsdlVersion() {
        return this.wsdlVersion;
    }

    @Override
    public Property<String> getCatalog() {
        return this.catalog;
    }

    @Override
    public Property<Boolean> getExtendedSoapHeaders() {
        return this.extendedSoapHeaders;
    }

    @Override
    public Property<String> getValidateWsdl() {
        return this.validateWsdl;
    }

    @Override
    public Property<Boolean> getNoTypes() {
        return this.noTypes;
    }

    @Override
    public Property<String> getFaultSerialVersionUid() {
        return this.faultSerialVersionUid;
    }

    @Override
    public Property<String> getExceptionSuper() {
        return this.exceptionSuper;
    }

    @Override
    public ListProperty<String> getSeiSuper() {
        return this.seiSuper;
    }

    @Override
    public Property<Boolean> getMarkGenerated() {
        return this.markGenerated;
    }

    @Override
    public Property<Boolean> getSuppressGeneratedDate() {
        return this.suppressGeneratedDate;
    }

    @Override
    public Property<String> getServiceName() {
        return this.serviceName;
    }

    @Override
    public Property<Boolean> getAutoNameResolution() {
        return this.autoNameResolution;
    }

    @Override
    public Property<Boolean> getNoAddressBinding() {
        return this.noAddressBinding;
    }

    @Override
    public Property<Boolean> getAllowElementRefs() {
        return this.allowElementRefs;
    }

    @Override
    public Property<String> getEncoding() {
        return this.encoding;
    }

    @Override
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public List<String> generateArgs() {
        boolean first;
        StringBuilder sb;
        ArrayList<String> command = new ArrayList<String>();
        if (this.encoding.isPresent()) {
            command.add("-encoding");
            command.add((String)this.encoding.get());
        }
        if (this.packageNames.isPresent()) {
            ((List)this.packageNames.get()).forEach(value -> {
                command.add("-p");
                command.add((String)value);
            });
        }
        if (this.namespaceExcludes.isPresent()) {
            ((List)this.namespaceExcludes.get()).forEach(value -> {
                command.add("-nexclude");
                command.add((String)value);
            });
        }
        command.add("-d");
        command.add(((Directory)this.outputDir.get()).getAsFile().getAbsolutePath());
        if (this.bindingFiles.isPresent()) {
            ((Set)this.bindingFiles.get()).forEach(value -> {
                RegularFile bindingFile = this.layout.getProjectDirectory().file(value);
                command.add("-b");
                command.add(bindingFile.getAsFile().toURI().toString());
            });
        }
        if (this.frontend.isPresent()) {
            command.add("-fe");
            command.add((String)this.frontend.get());
        }
        if (this.databinding.isPresent()) {
            command.add("-db");
            command.add((String)this.databinding.get());
        }
        if (this.wsdlVersion.isPresent()) {
            command.add("-wv");
            command.add((String)this.wsdlVersion.get());
        }
        if (this.catalog.isPresent()) {
            command.add("-catalog");
            command.add((String)this.catalog.get());
        }
        if (this.extendedSoapHeaders.isPresent() && ((Boolean)this.extendedSoapHeaders.get()).booleanValue()) {
            command.add("-exsh");
            command.add("true");
        }
        if (this.noTypes.isPresent() && ((Boolean)this.noTypes.get()).booleanValue()) {
            command.add("-noTypes");
        }
        if (this.allowElementRefs.isPresent() && ((Boolean)this.allowElementRefs.get()).booleanValue()) {
            command.add("-allowElementReferences");
        }
        if (this.validateWsdl.isPresent()) {
            command.add("-validate=" + (String)this.validateWsdl.get());
        }
        if (this.markGenerated.isPresent() && ((Boolean)this.markGenerated.get()).booleanValue()) {
            command.add("-mark-generated");
        }
        if (this.suppressGeneratedDate.isPresent() && ((Boolean)this.suppressGeneratedDate.get()).booleanValue()) {
            command.add("-suppress-generated-date");
        }
        if (this.defaultExcludesNamespace.isPresent()) {
            command.add("-dex");
            command.add(((Boolean)this.defaultExcludesNamespace.get()).toString());
        }
        if (this.defaultNamespacePackageMapping.isPresent()) {
            command.add("-dns");
            command.add(((Boolean)this.defaultNamespacePackageMapping.get()).toString());
        }
        if (this.serviceName.isPresent()) {
            command.add("-sn");
            command.add((String)this.serviceName.get());
        }
        if (this.faultSerialVersionUid.isPresent()) {
            command.add("-faultSerialVersionUID");
            command.add((String)this.faultSerialVersionUid.get());
        }
        if (this.exceptionSuper.isPresent()) {
            command.add("-exceptionSuper");
            command.add((String)this.exceptionSuper.get());
        }
        if (this.seiSuper.isPresent()) {
            ((List)this.seiSuper.get()).forEach(value -> {
                command.add("-seiSuper");
                command.add((String)value);
            });
        }
        if (this.autoNameResolution.isPresent() && ((Boolean)this.autoNameResolution.get()).booleanValue()) {
            command.add("-autoNameResolution");
        }
        if (this.noAddressBinding.isPresent() && ((Boolean)this.noAddressBinding.get()).booleanValue()) {
            command.add("-noAddressBinding");
        }
        if (this.xjcArgs.isPresent()) {
            ((List)this.xjcArgs.get()).forEach(value -> command.add("-xjc" + value));
        }
        if (this.extraArgs.isPresent()) {
            command.addAll((Collection)this.extraArgs.get());
        }
        if (this.wsdlLocation.isPresent()) {
            command.add("-wsdlLocation");
            command.add((String)this.wsdlLocation.get());
        }
        if (this.wsdlList.isPresent() && ((Boolean)this.wsdlList.get()).booleanValue()) {
            command.add("-wsdlList");
        }
        if (this.verbose.isPresent() && ((Boolean)this.verbose.get()).booleanValue()) {
            command.add("-verbose");
        }
        if (this.asyncMethods.isPresent() && !((List)this.asyncMethods.get()).isEmpty()) {
            sb = new StringBuilder("-asyncMethods");
            sb.append("=");
            first = true;
            for (String value2 : (List)this.asyncMethods.get()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(value2);
                first = false;
            }
            command.add(sb.toString());
        }
        if (this.bareMethods.isPresent() && !((List)this.bareMethods.get()).isEmpty()) {
            sb = new StringBuilder("-bareMethods");
            sb.append("=");
            first = true;
            for (String value2 : (List)this.bareMethods.get()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(value2);
                first = false;
            }
            command.add(sb.toString());
        }
        if (this.mimeMethods.isPresent() && !((List)this.mimeMethods.get()).isEmpty()) {
            sb = new StringBuilder("-mimeMethods");
            sb.append("=");
            first = true;
            for (String value2 : (List)this.mimeMethods.get()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(value2);
                first = false;
            }
            command.add(sb.toString());
        }
        if (!this.wsdl.isPresent()) {
            throw new GradleException("'wsdl' property is not present");
        }
        command.add(((RegularFile)this.wsdl.get()).getAsFile().toURI().toString());
        return command;
    }
}

