/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen;

import io.mateo.cxf.codegen.CxfCodegenExtension;
import io.mateo.cxf.codegen.wsdl2java.Wsdl2Java;
import io.mateo.cxf.codegen.wsdl2java.Wsdl2JavaTask;
import io.mateo.cxf.codegen.wsdl2java.WsdlOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;

public class CxfCodegenPlugin
implements Plugin<Project> {
    private static final String VALID_CONTAINER_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("[A-Za-z0-9_\\-.]+");
    private static final String WSDL2JAVA_TOOL_MAIN_CLASS = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    public static final String CXF_CODEGEN_CONFIGURATION_NAME = "cxfCodegen";
    public static final String CXF_CODEGEN_EXTENSION_NAME = "cxfCodegen";
    public static final String WSDL2JAVA_TASK_NAME = "wsdl2java";
    public static final String WSDL2JAVA_GROUP = "wsdl2java";
    static final String DEFAULT_CXF_VERSION = "3.5.2";

    public void apply(Project project) {
        CxfCodegenExtension extension = (CxfCodegenExtension)project.getExtensions().create("cxfCodegen", CxfCodegenExtension.class, new Object[0]);
        NamedDomainObjectProvider<Configuration> cxfCodegenConfiguration = this.createConfiguration(project);
        this.configureWsdl2JavaTaskConventions(project, cxfCodegenConfiguration);
        this.registerCodegenTasks(project, extension, cxfCodegenConfiguration);
        this.addToSourceSet(project, extension);
        this.registerAggregateTask(project);
        this.validateWsdlContainerWhenComplete(project, extension);
    }

    private void configureWsdl2JavaTaskConventions(Project project, NamedDomainObjectProvider<Configuration> cxfCodegenConfiguration) {
        project.getTasks().withType(Wsdl2Java.class).configureEach(task -> {
            try {
                task.getMainClass().set((Object)WSDL2JAVA_TOOL_MAIN_CLASS);
            }
            catch (NoSuchMethodError ignored) {
                task.setMain(WSDL2JAVA_TOOL_MAIN_CLASS);
            }
            task.setClasspath((FileCollection)cxfCodegenConfiguration.get());
            task.setGroup("wsdl2java");
            task.setDescription("Generates Java sources for '" + task.getName() + "'");
        });
    }

    private void validateWsdlContainerWhenComplete(Project project, CxfCodegenExtension extension) {
        project.afterEvaluate(evaluated -> {
            for (WsdlOption wsdlOption : extension.getWsdl2java()) {
                String name = wsdlOption.getName();
                if (CONTAINER_NAME_PATTERN.matcher(name).matches()) continue;
                throw new InvalidUserDataException("Name '" + name + "' is not valid for the cxfCodegen container. Must match match regex " + VALID_CONTAINER_NAME_REGEX);
            }
        });
    }

    private void registerAggregateTask(Project project) {
        TaskCollection wsdl2JavaTasks = project.getTasks().withType(Wsdl2JavaTask.class);
        TaskCollection wsdl2Javas = project.getTasks().withType(Wsdl2Java.class);
        project.getTasks().register("wsdl2java", task -> {
            task.dependsOn(new Object[]{wsdl2JavaTasks, wsdl2Javas});
            task.setGroup("wsdl2java");
            task.setDescription("Runs all wsdl2java tasks");
        });
    }

    private void addToSourceSet(Project project, CxfCodegenExtension extension) {
        project.getPluginManager().withPlugin("java-base", plugin -> extension.getWsdl2java().all(option -> project.getExtensions().configure(SourceSetContainer.class, sourceSets -> sourceSets.named("main", main -> main.getJava().srcDir((Object)project.provider(() -> option.getOutputDir().getAsFile()))))));
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(Wsdl2Java.class).all(wsdl2Java -> {
            if (((Boolean)wsdl2Java.getAddToMainSourceSet().get()).booleanValue()) {
                evaluated.getExtensions().configure(SourceSetContainer.class, sourceSets -> sourceSets.named("main", main -> main.getJava().srcDir((Object)wsdl2Java.getWsdl2JavaOptions().getOutputDir())));
            }
        }));
    }

    private void registerCodegenTasks(Project project, CxfCodegenExtension extension, NamedDomainObjectProvider<Configuration> configuration) {
        extension.getWsdl2java().all(option -> {
            String name = option.getName().substring(0, 1).toUpperCase() + option.getName().substring(1);
            project.getTasks().register("cleanWsdl2java" + name, Delete.class, task -> task.delete(new Object[]{option.getOutputDir()}));
            project.getTasks().register("wsdl2java" + name, Wsdl2JavaTask.class, task -> {
                task.getOutputs().dir(option.getOutputDir().get());
                task.getInputs().file(option.getWsdl().get());
                try {
                    task.getMainClass().set((Object)WSDL2JAVA_TOOL_MAIN_CLASS);
                }
                catch (NoSuchMethodError ignored) {
                    task.setMain(WSDL2JAVA_TOOL_MAIN_CLASS);
                }
                task.setClasspath((FileCollection)configuration.get());
                task.setGroup("wsdl2java");
                task.setDescription("Generates Java sources for '" + option.getName() + "'");
                task.setArgs(option.generateArgs());
            });
        });
    }

    private NamedDomainObjectProvider<Configuration> createConfiguration(Project project) {
        return project.getConfigurations().register("cxfCodegen", configuration -> {
            configuration.setVisible(false);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            configuration.setDescription("Classpath for CXF Codegen.");
            configuration.getDependencies().addAll(this.createDependencies(project));
        });
    }

    private List<Dependency> createDependencies(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-core:3.5.2"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-common:3.5.2"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-core:3.5.2"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-databinding-jaxb:3.5.2"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-frontend-jaxws:3.5.2"));
        ModuleDependency dependency = (ModuleDependency)dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-frontend-javascript:3.5.2");
        HashMap<String, String> excludeProperties = new HashMap<String, String>();
        excludeProperties.put("group", "org.apache.cxf");
        excludeProperties.put("module", "cxf-rt-frontend-simple");
        dependency.exclude(excludeProperties);
        dependencies.add((Dependency)dependency);
        return dependencies;
    }
}

