/*
 * Decompiled with CFR 0.152.
 */
package io.mateo.cxf.codegen;

import io.mateo.cxf.codegen.CxfCodegenExtension;
import io.mateo.cxf.codegen.wsdl2java.Wsdl2JavaTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSetContainer;

public class CxfCodegenPlugin
implements Plugin<Project> {
    public static final String CXF_CODEGEN_CONFIGURATION_NAME = "cxfCodegen";
    public static final String CXF_CODEGEN_EXTENSION_NAME = "cxfCodegen";
    public static final String WSDL2JAVA_TASK_NAME = "wsdl2java";
    public static final String WSDL2JAVA_GROUP = "wsdl2java";
    static final String DEFAULT_CXF_VERSION = "3.4.3";

    public void apply(Project project) {
        CxfCodegenExtension extension = (CxfCodegenExtension)project.getExtensions().create("cxfCodegen", CxfCodegenExtension.class, new Object[0]);
        this.registerCodegenTasks(project, extension, this.createConfiguration(project));
        this.addToSourceSet(project, extension);
        this.registerAggregateTask(project);
    }

    private void registerAggregateTask(Project project) {
        project.getTasks().register("wsdl2java", task -> {
            task.setDependsOn((Iterable)project.getTasks().withType(Wsdl2JavaTask.class));
            task.setGroup("wsdl2java");
            task.setDescription("Runs all wsdl2java tasks");
        });
    }

    private void addToSourceSet(Project project, CxfCodegenExtension extension) {
        project.getPluginManager().withPlugin("java-base", plugin -> extension.getWsdl2java().all(option -> project.getExtensions().configure(SourceSetContainer.class, sourceSets -> sourceSets.named("main", main -> main.getJava().srcDir((Object)project.provider(() -> option.getOutputDir().getAsFile()))))));
    }

    private void registerCodegenTasks(Project project, CxfCodegenExtension extension, NamedDomainObjectProvider<Configuration> configuration) {
        extension.getWsdl2java().all(option -> {
            String name = option.getName().substring(0, 1).toUpperCase() + option.getName().substring(1);
            project.getTasks().register("wsdl2java" + name, Wsdl2JavaTask.class, task -> {
                task.getOutputs().dir(option.getOutputDir().get());
                task.setMain("org.apache.cxf.tools.wsdlto.WSDLToJava");
                task.setClasspath((FileCollection)configuration.get());
                task.setGroup("wsdl2java");
                task.setDescription("Generates Java sources for '" + option.getName() + "'");
                task.setArgs(option.generateArgs());
            });
        });
    }

    private NamedDomainObjectProvider<Configuration> createConfiguration(Project project) {
        return project.getConfigurations().register("cxfCodegen", configuration -> {
            configuration.setVisible(false);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            configuration.setDescription("Classpath for CXF Codegen.");
            configuration.getDependencies().addAll(this.createDependencies(project));
        });
    }

    private List<Dependency> createDependencies(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-core:3.4.3"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-common:3.4.3"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-core:3.4.3"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-databinding-jaxb:3.4.3"));
        dependencies.add(dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-frontend-jaxws:3.4.3"));
        ModuleDependency dependency = (ModuleDependency)dependencyHandler.create((Object)"org.apache.cxf:cxf-tools-wsdlto-frontend-javascript:3.4.3");
        HashMap<String, String> excludeProperties = new HashMap<String, String>();
        excludeProperties.put("group", "org.apache.cxf");
        excludeProperties.put("module", "cxf-rt-frontend-simple");
        dependency.exclude(excludeProperties);
        dependencies.add((Dependency)dependency);
        return dependencies;
    }
}

