/*
 * Decompiled with CFR 0.152.
 */
package io.macgyver.okrest3.converter.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import io.macgyver.okrest3.converter.ResponseBodyConverter;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.Response;

public class JacksonResponseBodyConverter
extends ResponseBodyConverter {
    ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean supports(Class<? extends Object> t, Optional<MediaType> mediaType) {
        return JsonNode.class.isAssignableFrom(t);
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T convert(Response r, Class<? extends T> t) throws IOException {
        try {
            JsonNode jsonNode;
            try (InputStream is = r.body().byteStream();){
                jsonNode = this.mapper.readTree(is);
            }
            return (T)jsonNode;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (r != null) {
                r.body().close();
            }
        }
    }
}

