/*
 * Decompiled with CFR 0.152.
 */
package io.macgyver.okrest3.converter;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.macgyver.okrest3.converter.DefaultResponseErrorHandler;
import io.macgyver.okrest3.converter.RequestBodyConverter;
import io.macgyver.okrest3.converter.ResponseBodyConverter;
import io.macgyver.okrest3.converter.ResponseErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterRegistry {
    boolean immutable = false;
    Logger logger = LoggerFactory.getLogger(ConverterRegistry.class);
    List<RequestBodyConverter> requestConverters = Lists.newCopyOnWriteArrayList();
    List<ResponseBodyConverter> responseConverters = Lists.newCopyOnWriteArrayList();
    private static ConverterRegistry defaultRegistry = new ConverterRegistry();
    private ResponseErrorHandler defaultResponseErrorHandler = new DefaultResponseErrorHandler();

    public ConverterRegistry() {
        this.requestConverters.add(new PassThroughRequestBodyConverter());
        this.addRequestBodyConverter("io.macgyver.okrest3.converter.jackson.JacksonRequestBodyConverter", false);
        this.requestConverters.add(new StringRequestBodyConverter());
        this.requestConverters.add(new FileRequestBodyConverter());
        this.requestConverters.add(new ByteArrayRequestBodyConverter());
        this.addResponseBodyConverter("io.macgyver.okrest3.converter.jackson.JacksonResponseBodyConverter", false);
        this.responseConverters.add(new StringResponseBodyConverter());
        this.responseConverters.add(new ByteArrayResponseBodyConverter());
        this.responseConverters.add(new InputStreamResponseBodyConverter());
        this.responseConverters.add(new ReaderResponseBodyConverter());
    }

    public static ConverterRegistry defaultRegistry() {
        return defaultRegistry;
    }

    public static ConverterRegistry newRegistry() {
        return new ConverterRegistry();
    }

    public void markImmutable() {
        this.immutable = true;
    }

    public void assertNotImmutable() {
        Preconditions.checkState((!this.immutable ? 1 : 0) != 0, (Object)"ConverterRegistry is immutable after construction");
    }

    public void addResponseBodyConverter(ResponseBodyConverter c) {
        this.assertNotImmutable();
        Preconditions.checkNotNull((Object)c);
        this.responseConverters.add(c);
    }

    public void addRequestBodyConverter(RequestBodyConverter c) {
        this.assertNotImmutable();
        Preconditions.checkNotNull((Object)c);
        this.requestConverters.add(c);
    }

    public void addRequestBodyConverter(String s, boolean failOnError) {
        block4: {
            this.assertNotImmutable();
            try {
                RequestBodyConverter c = (RequestBodyConverter)Class.forName(s).newInstance();
                this.addRequestBodyConverter(c);
            }
            catch (Throwable e) {
                if (failOnError) {
                    throw new IllegalArgumentException(e);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("could not load converter: " + s, e);
                }
                if (!this.logger.isWarnEnabled() || this.logger.isDebugEnabled()) break block4;
                this.logger.info("could not load converter: " + s);
            }
        }
    }

    public void addResponseBodyConverter(String s, boolean failOnError) {
        block4: {
            this.assertNotImmutable();
            try {
                ResponseBodyConverter c = (ResponseBodyConverter)Class.forName(s).newInstance();
                this.addResponseBodyConverter(c);
            }
            catch (Throwable e) {
                if (failOnError) {
                    throw new IllegalArgumentException(e);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("could not load converter: " + s, e);
                }
                if (!this.logger.isWarnEnabled() || this.logger.isDebugEnabled()) break block4;
                this.logger.info("could not load converter: " + s);
            }
        }
    }

    public RequestBodyConverter findRequestConverter(Object input) {
        for (RequestBodyConverter c : this.requestConverters) {
            if (!c.supports(input)) continue;
            return c;
        }
        throw new IllegalArgumentException("could not find type converter for " + input.getClass());
    }

    public ResponseBodyConverter findResponseConverter(Class<?> desiredType, Optional<MediaType> mt) {
        for (ResponseBodyConverter c : this.responseConverters) {
            if (!c.supports(desiredType, mt)) continue;
            return c;
        }
        throw new IllegalArgumentException("coult not find converter for: " + desiredType);
    }

    public ResponseErrorHandler getDefaultResponseErrorHandler() {
        return this.defaultResponseErrorHandler;
    }

    public void setDefaultResponseErrorHandler(ResponseErrorHandler h) {
        Preconditions.checkNotNull((Object)h);
        this.defaultResponseErrorHandler = h;
    }

    public ResponseErrorHandler findErrorHandler(Class<? extends Object> clazz) {
        return this.defaultResponseErrorHandler;
    }

    public static class PassThroughRequestBodyConverter
    extends RequestBodyConverter {
        @Override
        public boolean supports(Object input) {
            return input instanceof RequestBody;
        }

        @Override
        public RequestBody convert(Object input) {
            return (RequestBody)input;
        }
    }

    public static class StringRequestBodyConverter
    extends RequestBodyConverter {
        @Override
        public boolean supports(Object input) {
            return input instanceof String;
        }

        @Override
        public RequestBody convert(Object input) {
            return RequestBody.create(null, (String)((String)input));
        }
    }

    public static class ReaderResponseBodyConverter
    extends ResponseBodyConverter {
        @Override
        public boolean supports(Class<? extends Object> t, Optional<MediaType> mediaType) {
            return Reader.class.isAssignableFrom(t);
        }

        @Override
        public <T> T convert(Response r, Class<? extends T> t) throws IOException {
            return (T)r.body().charStream();
        }
    }

    public static class ByteArrayResponseBodyConverter
    extends ResponseBodyConverter {
        @Override
        public boolean supports(Class<? extends Object> t, Optional<MediaType> mediaType) {
            return byte[].class.isAssignableFrom(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T convert(Response r, Class<? extends T> t) throws IOException {
            try {
                byte[] byArray = r.body().bytes();
                return (T)byArray;
            }
            finally {
                r.body().close();
            }
        }
    }

    public static class InputStreamResponseBodyConverter
    extends ResponseBodyConverter {
        @Override
        public boolean supports(Class<? extends Object> t, Optional<MediaType> mediaType) {
            return InputStream.class.isAssignableFrom(t);
        }

        @Override
        public <T> T convert(Response r, Class<? extends T> t) throws IOException {
            return (T)r.body().byteStream();
        }
    }

    public static class StringResponseBodyConverter
    extends ResponseBodyConverter {
        public boolean supports(Class<?> t, Optional<MediaType> mediaType) {
            return String.class.isAssignableFrom(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T convert(Response r, Class<? extends T> t) throws IOException {
            try {
                String string = r.body().string();
                return (T)string;
            }
            finally {
                r.body().close();
            }
        }
    }

    public static class FileRequestBodyConverter
    extends RequestBodyConverter {
        @Override
        public boolean supports(Object input) {
            return input instanceof File;
        }

        @Override
        public RequestBody convert(Object input) {
            return RequestBody.create(null, (File)((File)input));
        }
    }

    public static class ByteArrayRequestBodyConverter
    extends RequestBodyConverter {
        @Override
        public boolean supports(Object input) {
            return input instanceof byte[];
        }

        @Override
        public RequestBody convert(Object input) {
            return RequestBody.create(null, (byte[])((byte[])input));
        }
    }
}

