/*
 * Decompiled with CFR 0.152.
 */
package io.macgyver.okrest3;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.macgyver.okrest3.OkRestClient;
import io.macgyver.okrest3.OkRestException;
import io.macgyver.okrest3.OkRestResponse;
import io.macgyver.okrest3.compat.OkUriBuilder;
import io.macgyver.okrest3.converter.RequestBodyConverter;
import io.macgyver.okrest3.converter.ResponseBodyConverter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkRestTarget {
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    protected OkRestClient okRestClient;
    protected OkUriBuilder uriBuilder = new OkUriBuilder();
    protected Headers headers = Headers.of((String[])new String[0]);

    ResponseBodyConverter findResponseConverter(Class<?> x, Optional<MediaType> t) {
        ResponseBodyConverter converter = this.getOkRestClient().getConverterRegistry().findResponseConverter(x, t);
        return converter;
    }

    RequestBodyConverter findRequestConverter(Object bodyInput) {
        RequestBodyConverter converter = this.getOkRestClient().getConverterRegistry().findRequestConverter(bodyInput);
        return converter;
    }

    protected OkRestTarget() {
    }

    public OkRestTarget clone() {
        OkRestTarget r = new OkRestTarget();
        r.okRestClient = this.okRestClient;
        r.headers = this.headers.newBuilder().build();
        r.uriBuilder = this.uriBuilder.clone();
        return r;
    }

    public OkRestTarget header(String key, String val) {
        OkRestTarget c = this.clone();
        c.headers = this.headers.newBuilder().set(key, val).build();
        return c;
    }

    public OkRestTarget accept(String val) {
        return this.header("Accept", val);
    }

    public OkRestTarget contentType(String val) {
        return this.header("Content-type", val);
    }

    public OkRestTarget addHeader(String key, String val) {
        OkRestTarget c = this.clone();
        c.headers = this.headers.newBuilder().add(key, val).build();
        return c;
    }

    public OkRestTarget removeHeader(String key) {
        OkRestTarget c = this.clone();
        c.headers = this.headers.newBuilder().removeAll(key).build();
        return c;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public OkRestTarget queryParam(Object ... vals) {
        if (vals == null || vals.length == 0) {
            return this;
        }
        OkRestTarget copy = this.clone();
        if (vals != null && vals.length % 2 != 0) {
            throw new IllegalArgumentException("queryParameters() must have an even number of key value pair arguments");
        }
        for (int i = 0; vals != null && i < vals.length; i += 2) {
            String key = Objects.toString(vals[i], "");
            String val = Objects.toString(vals[i + 1], "");
            if (Strings.isNullOrEmpty((String)key)) {
                throw new IllegalArgumentException("query parameter key cannot be null or empty");
            }
            copy.uriBuilder.queryParam(key, val);
        }
        return copy;
    }

    public OkRestTarget queryParam(Map<?, ?> m) {
        if (m == null) {
            return this;
        }
        OkRestTarget copy = this.clone();
        m.entrySet().forEach(entry -> {
            String stringKey = Objects.toString(entry.getKey(), "");
            if (Strings.isNullOrEmpty((String)stringKey)) {
                throw new IllegalArgumentException("query parameter key cannot be null or empty");
            }
            String stringVal = Objects.toString(entry.getValue(), "");
            copy.uriBuilder.queryParam(stringKey, stringVal);
        });
        return copy;
    }

    public OkRestTarget queryParameMultiValue(String key, Object ... vals) {
        OkRestTarget copy = this.clone();
        copy.uriBuilder.queryParam(key, vals);
        return copy;
    }

    public OkRestTarget path(String path) {
        OkRestTarget copy = this.clone();
        copy.uriBuilder.path(path);
        return copy;
    }

    public InvocationBuilder post(RequestBody body) {
        return this.request().post(body);
    }

    public InvocationBuilder post(Object data) {
        return this.request().post(data);
    }

    public InvocationBuilder put(RequestBody body) {
        return this.request().put(body);
    }

    public InvocationBuilder put(Object data) {
        return this.request().put(data);
    }

    public InvocationBuilder patch(RequestBody body) {
        return this.request().patch(body);
    }

    public InvocationBuilder patch(Object data) {
        return this.request().patch(data);
    }

    public InvocationBuilder head(RequestBody body) {
        return this.request().head(body);
    }

    public InvocationBuilder head(Object data) {
        return this.request().head(data);
    }

    public InvocationBuilder get() {
        return this.request().get();
    }

    public InvocationBuilder delete() {
        return this.request().delete();
    }

    public OkRestTarget uri(URI uri) {
        return this.url(uri);
    }

    public OkRestTarget uri(String uri) {
        return this.url(uri);
    }

    public OkRestTarget uri(URL uri) {
        return this.url(uri);
    }

    public OkRestTarget url(URL url) {
        return this.url(url.toExternalForm());
    }

    public OkRestTarget url(URI uri) {
        try {
            return this.url(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public OkRestTarget url(String url) {
        OkRestTarget copy = this.clone();
        copy.uriBuilder.uri(url);
        return copy;
    }

    protected InvocationBuilder request() {
        Request.Builder rb = new Request.Builder();
        rb = rb.url(this.uriBuilder.build(new Object[0]).toString());
        InvocationBuilder b = new InvocationBuilder(rb);
        b.okBuilder.headers(this.headers);
        return b;
    }

    public String getUrl() {
        return this.uriBuilder.build(new Object[0]).toString();
    }

    public OkUriBuilder getOkUriBuilder() {
        return this.uriBuilder;
    }

    public OkRestClient getOkRestClient() {
        return this.okRestClient;
    }

    public OkHttpClient getOkHttpClient() {
        Preconditions.checkState((this.okRestClient != null ? 1 : 0) != 0, (Object)"OkRestClient not set");
        return this.okRestClient.okHttpClient;
    }

    protected Call newCall(Request.Builder b) {
        return this.getOkHttpClient().newCall(b.build());
    }

    public URI toURI() {
        return this.uriBuilder.build(new Object[0]);
    }

    public class InvocationBuilder {
        Request.Builder okBuilder = new Request.Builder();

        InvocationBuilder(Request.Builder okBuilder) {
            this.okBuilder = okBuilder;
        }

        public OkRestResponse execute() {
            Response response = null;
            try {
                Call c = OkRestTarget.this.getOkHttpClient().newCall(this.okBuilder.build());
                response = c.execute();
                return new OkRestResponse(OkRestTarget.this, response);
            }
            catch (IOException e) {
                if (response != null) {
                    response.body().close();
                }
                throw new OkRestException(e);
            }
        }

        public <T> T execute(Class<? extends T> x) {
            OkRestResponse okr = this.execute();
            return okr.getBody(x);
        }

        public Request.Builder okBuilder() {
            return this.okBuilder;
        }

        InvocationBuilder post(Object body) {
            return this.post(OkRestTarget.this.findRequestConverter(body).convert(body));
        }

        InvocationBuilder post(RequestBody body) {
            return new InvocationBuilder(this.okBuilder.post(body));
        }

        InvocationBuilder get() {
            return new InvocationBuilder(this.okBuilder.get());
        }

        InvocationBuilder delete() {
            return new InvocationBuilder(this.okBuilder.delete());
        }

        InvocationBuilder delete(RequestBody body) {
            return new InvocationBuilder(this.okBuilder.delete());
        }

        InvocationBuilder put(RequestBody body) {
            return new InvocationBuilder(this.okBuilder.put(body));
        }

        InvocationBuilder put(Object body) {
            return this.put(OkRestTarget.this.findRequestConverter(body).convert(body));
        }

        InvocationBuilder patch(RequestBody body) {
            return new InvocationBuilder(this.okBuilder.patch(body));
        }

        InvocationBuilder patch(Object body) {
            return this.patch(OkRestTarget.this.findRequestConverter(body).convert(body));
        }

        InvocationBuilder head(RequestBody body) {
            return new InvocationBuilder(this.okBuilder.head());
        }

        InvocationBuilder head(Object body) {
            return this.head(OkRestTarget.this.findRequestConverter(body).convert(body));
        }

        InvocationBuilder method(String method, RequestBody body) {
            return new InvocationBuilder(this.okBuilder.method(method, body));
        }

        public InvocationBuilder header(String key, String val) {
            return new InvocationBuilder(this.okBuilder.header(key, val));
        }

        public InvocationBuilder addHeader(String key, String val) {
            return new InvocationBuilder(this.okBuilder.addHeader(key, val));
        }

        public InvocationBuilder removeHeader(String key) {
            return new InvocationBuilder(this.okBuilder.removeHeader(key));
        }
    }
}

