/*
 * Decompiled with CFR 0.152.
 */
package io.macgyver.okrest3;

import com.google.common.base.Optional;
import io.macgyver.okrest3.OkRestException;
import io.macgyver.okrest3.OkRestTarget;
import io.macgyver.okrest3.converter.ResponseBodyConverter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Response;

public class OkRestResponse {
    Response response;
    OkRestTarget okRestTarget;

    public OkRestResponse(OkRestTarget target, Response r) {
        this.okRestTarget = target;
        this.response = r;
    }

    public Response response() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getBody(Class<? extends T> clazz) throws OkRestException {
        Response response = this.response();
        if (response.isSuccessful()) {
            try {
                String contentType = response.header("content-type");
                MediaType mt = contentType != null ? MediaType.parse((String)response.header("Content-type")) : null;
                ResponseBodyConverter c = this.okRestTarget.findResponseConverter(clazz, (Optional<MediaType>)Optional.fromNullable((Object)mt));
                return c.convert(response, clazz);
            }
            catch (IOException e) {
                if (response != null) {
                    response.body().close();
                }
                throw new OkRestException(e);
            }
            catch (RuntimeException e) {
                if (response != null) {
                    response.body().close();
                }
                throw e;
            }
        }
        try {
            T t = this.okRestTarget.getOkRestClient().getConverterRegistry().findErrorHandler(clazz).handleError(response, clazz);
            return t;
        }
        finally {
            if (response != null) {
                response.body().close();
            }
        }
    }
}

