/*
 * Decompiled with CFR 0.152.
 */
package io.macgyver.okrest3;

import com.google.common.base.Preconditions;
import io.macgyver.okrest3.BasicAuthInterceptor;
import io.macgyver.okrest3.OkHttpClientConfigurer;
import io.macgyver.okrest3.OkRestClientConfigurer;
import io.macgyver.okrest3.OkRestTarget;
import io.macgyver.okrest3.TLSUtil;
import io.macgyver.okrest3.compat.OkUriBuilder;
import io.macgyver.okrest3.converter.ConverterRegistry;
import io.macgyver.okrest3.converter.ConverterRegistryConfigurer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkRestClient {
    OkHttpClient okHttpClient;
    ConverterRegistry registry = null;
    static AtomicLong constructorCount = new AtomicLong(0L);

    OkRestClient() {
    }

    public OkRestTarget url(String url) {
        return this.uri(url);
    }

    public OkRestTarget url(URI url) {
        return this.uri(url);
    }

    public OkRestTarget url(URL url) {
        return this.uri(url);
    }

    public OkRestTarget uri(URL url) {
        return this.uri(url.toExternalForm());
    }

    public OkRestTarget uri(URI uri) {
        try {
            return this.uri(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public OkRestTarget uri(String uri) {
        OkRestTarget r = new OkRestTarget();
        r.okRestClient = this;
        r.uriBuilder = new OkUriBuilder().uri(uri);
        r.headers = Headers.of((String[])new String[0]);
        return r;
    }

    public OkHttpClient getOkHttpClient() {
        Preconditions.checkState((this.okHttpClient != null ? 1 : 0) != 0, (Object)"okHttpClient not set");
        return this.okHttpClient;
    }

    public ConverterRegistry getConverterRegistry() {
        Preconditions.checkState((this.registry != null ? 1 : 0) != 0, (Object)"ConverterRegistry not set");
        return this.registry;
    }

    public static class Builder {
        boolean buildCalled = false;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        ConverterRegistry converterRegistry = new ConverterRegistry();
        OkHttpClient directlySpecifiedClient = null;

        public Builder withOkHttpClient(OkHttpClient client) {
            this.directlySpecifiedClient = client;
            return this;
        }

        public Builder withOkHttpClientConfig(OkHttpClientConfigurer cfg) {
            cfg.accept(this.okHttpClientBuilder);
            return this;
        }

        public Builder withInterceptor(Interceptor interceptor) {
            this.withOkHttpClientConfig(it -> it.addInterceptor(interceptor));
            return this;
        }

        public Builder disableCertificateVerification() {
            return this.withOkHttpClientConfig(cfg -> {
                cfg.hostnameVerifier((HostnameVerifier)new TLSUtil.TrustAllHostnameVerifier());
                cfg.sslSocketFactory(TLSUtil.createTrustAllSSLContext().getSocketFactory());
            });
        }

        public Builder withOkRestClientConfig(OkRestClientConfigurer okRestBuilderConsumer) {
            okRestBuilderConsumer.accept(this);
            return this;
        }

        public Builder withOkHttpClientBuilder(OkHttpClient.Builder builder) {
            this.okHttpClientBuilder = builder;
            this.directlySpecifiedClient = null;
            return this;
        }

        public Builder withBasicAuth(String username, String password) {
            this.okHttpClientBuilder.addInterceptor((Interceptor)new BasicAuthInterceptor(username, password));
            return this;
        }

        public Builder withConverterRegistryConfig(ConverterRegistryConfigurer converterRegistryConsumer) {
            converterRegistryConsumer.accept(this.converterRegistry);
            return this;
        }

        public OkRestClient build() {
            Preconditions.checkState((!this.buildCalled ? 1 : 0) != 0, (Object)"OkRestClient.Builder.build() may only be called once");
            this.buildCalled = true;
            OkHttpClient c = null;
            c = this.directlySpecifiedClient != null ? this.directlySpecifiedClient : this.okHttpClientBuilder.build();
            OkRestClient restClient = new OkRestClient();
            restClient.okHttpClient = c;
            restClient.registry = this.converterRegistry;
            restClient.getConverterRegistry().markImmutable();
            this.okHttpClientBuilder = null;
            this.converterRegistry = null;
            this.directlySpecifiedClient = null;
            Preconditions.checkState((restClient.okHttpClient != null ? 1 : 0) != 0);
            Preconditions.checkState((restClient.registry != null ? 1 : 0) != 0);
            long count = constructorCount.incrementAndGet();
            if (count > 10L && count % 10L == 0L) {
                Logger logger = LoggerFactory.getLogger(Builder.class);
                logger.info("potential implementation mistake: {} OkRestClient instances created", (Object)count);
                logger.debug("diagnostic stack trace", (Throwable)new DiagnosticStackTrace());
            }
            return restClient;
        }
    }

    public static class DiagnosticStackTrace
    extends RuntimeException {
    }
}

