/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.support.http.HttpClient;
import io.lettuce.core.support.http.HttpClientProvider;
import io.lettuce.core.support.http.NettyHttpClient;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

@Experimental
public class NettyHttpClientProvider
implements HttpClientProvider {
    private static final InternalLogger logger;
    private static final int MIN_HTTP_IO_THREADS = 2;
    private static final int DEFAULT_HTTP_IO_THREADS;

    @Override
    public HttpClient createHttpClient() {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory("lettuce-http", true);
        return new NettyHttpClient(DEFAULT_HTTP_IO_THREADS, (ThreadFactory)threadFactory);
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("io.netty.handler.codec.http.HttpClientCodec");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    static {
        int threads;
        logger = InternalLoggerFactory.getInstance(NettyHttpClientProvider.class);
        DEFAULT_HTTP_IO_THREADS = threads = Math.max(1, SystemPropertyUtil.getInt((String)"io.lettuce.http.eventLoopThreads", (int)Math.max(2, Runtime.getRuntime().availableProcessors())));
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.lettuce.http.eventLoopThreads: {}", (Object)threads);
        }
    }
}

