/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.http.DefaultHttpResponse;
import io.lettuce.core.support.http.HttpClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class NettyHttpClient
implements HttpClient {
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    private final EventLoopGroup eventLoopGroup;
    private final boolean ownEventLoopGroup;

    NettyHttpClient() {
        this(null);
    }

    NettyHttpClient(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.ownEventLoopGroup = false;
        } else {
            this.eventLoopGroup = new MultiThreadIoEventLoopGroup(2, NioIoHandler.newFactory());
            this.ownEventLoopGroup = true;
        }
    }

    NettyHttpClient(int numberOfThreads, ThreadFactory threadFactory) {
        LettuceAssert.isTrue(numberOfThreads > 0, "Number of threads must be greater than zero");
        LettuceAssert.notNull((Object)threadFactory, "ThreadFactory must not be null");
        this.eventLoopGroup = new MultiThreadIoEventLoopGroup(numberOfThreads, threadFactory, NioIoHandler.newFactory());
        this.ownEventLoopGroup = true;
    }

    @Override
    public HttpClient.HttpConnection connect(URI uri, HttpClient.ConnectionConfig connectionConfig) throws IOException {
        try {
            return this.connectAsync(uri, connectionConfig).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to establish HTTP connection", Exceptions.unwrap(e));
        }
    }

    @Override
    public CompletableFuture<HttpClient.HttpConnection> connectAsync(URI uri, HttpClient.ConnectionConfig connectionConfig) {
        LettuceAssert.notNull((Object)uri, "URI must not be null");
        LettuceAssert.notNull((Object)connectionConfig, "ConnectionConfig must not be null");
        CompletableFuture<HttpClient.HttpConnection> future = new CompletableFuture<HttpClient.HttpConnection>();
        String scheme = uri.getScheme();
        if (scheme == null) {
            future.completeExceptionally(new IllegalArgumentException("URI scheme must not be null"));
            return future;
        }
        String host = uri.getHost();
        if (host == null) {
            future.completeExceptionally(new IllegalArgumentException("URI host must not be null"));
            return future;
        }
        boolean isHttps = "https".equalsIgnoreCase(scheme);
        int port = uri.getPort();
        if (port == -1) {
            port = isHttps ? 443 : 80;
        }
        SslContext sslContext = null;
        if (isHttps && connectionConfig.getSslOptions() != null) {
            try {
                SslContextBuilder builder = connectionConfig.getSslOptions().createSslContextBuilder();
                sslContext = builder.build();
            }
            catch (Exception e) {
                future.completeExceptionally(new IOException("Failed to create SSL context", e));
                return future;
            }
        }
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionConfig.getConnectionTimeout())).handler((ChannelHandler)new HttpConnectionInitializer(uri, isHttps, sslContext, connectionConfig.getReadTimeout()));
        ChannelFuture connectFuture = bootstrap.connect(host, port);
        connectFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                future.complete(new NettyHttpConnection(channelFuture.channel(), uri));
            } else {
                future.completeExceptionally(channelFuture.cause());
            }
        }));
        return future;
    }

    @Override
    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.ownEventLoopGroup) {
            Future shutdownFuture = this.eventLoopGroup.shutdownGracefully(quietPeriod, timeout, timeUnit);
            shutdownFuture.awaitUninterruptibly();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private static class SequentialHttpHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private final URI baseUri;
        private final Queue<PendingRequest> requestQueue = new ArrayDeque<PendingRequest>();
        private boolean requestInFlight = false;

        SequentialHttpHandler(URI baseUri) {
            this.baseUri = baseUri;
        }

        void sendRequest(Channel channel, FullHttpRequest request, CompletableFuture<HttpClient.Response> future) {
            channel.eventLoop().execute(() -> {
                PendingRequest pending = new PendingRequest(request, future);
                this.requestQueue.offer(pending);
                this.trySendNext(channel);
            });
        }

        private void trySendNext(Channel channel) {
            if (!this.requestInFlight && !this.requestQueue.isEmpty()) {
                this.requestInFlight = true;
                PendingRequest next = this.requestQueue.peek();
                channel.writeAndFlush((Object)next.request).addListener((GenericFutureListener)((ChannelFutureListener)writeResult -> {
                    if (!writeResult.isSuccess()) {
                        this.requestInFlight = false;
                        PendingRequest failed = this.requestQueue.poll();
                        if (failed != null && !failed.future.isDone()) {
                            failed.future.completeExceptionally(writeResult.cause());
                        }
                        this.trySendNext(channel);
                    }
                }));
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) {
            PendingRequest completed = this.requestQueue.poll();
            this.requestInFlight = false;
            if (completed == null) {
                throw new IllegalStateException("Received HTTP response with no pending request");
            }
            try {
                ByteBuf content = response.content();
                ByteBuffer buffer = ByteBuffer.allocate(content.readableBytes());
                content.readBytes(buffer);
                buffer.flip();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry header : response.headers()) {
                    headers.put((String)header.getKey(), (String)header.getValue());
                }
                DefaultHttpResponse httpResponse = DefaultHttpResponse.builder().statusCode(response.status().code()).body(buffer).headers(headers).build();
                completed.future.complete(httpResponse);
            }
            catch (Exception e) {
                completed.future.completeExceptionally(e);
            }
            this.trySendNext(ctx.channel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            PendingRequest pending;
            this.requestInFlight = false;
            while ((pending = this.requestQueue.poll()) != null) {
                if (pending.future.isDone()) continue;
                pending.future.completeExceptionally(cause);
            }
            ctx.close();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            PendingRequest pending;
            this.requestInFlight = false;
            while ((pending = this.requestQueue.poll()) != null) {
                if (pending.future.isDone()) continue;
                pending.future.completeExceptionally(new IOException("Connection closed"));
            }
            super.channelInactive(ctx);
        }

        private static class PendingRequest {
            final FullHttpRequest request;
            final CompletableFuture<HttpClient.Response> future;

            PendingRequest(FullHttpRequest request, CompletableFuture<HttpClient.Response> future) {
                this.request = request;
                this.future = future;
            }
        }
    }

    private static class NettyHttpConnection
    implements HttpClient.HttpConnection {
        private final Channel channel;
        private final URI baseUri;
        private final SequentialHttpHandler sequentialHandler;

        NettyHttpConnection(Channel channel, URI baseUri) {
            this.channel = channel;
            this.baseUri = baseUri;
            this.sequentialHandler = new SequentialHttpHandler(baseUri);
            channel.pipeline().addLast(new ChannelHandler[]{this.sequentialHandler});
        }

        @Override
        public HttpClient.Response execute(HttpClient.Request request) throws IOException {
            try {
                return this.executeAsync(request).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("HTTP request failed: " + request.getUri(), Exceptions.unwrap(e));
            }
        }

        @Override
        public CompletableFuture<HttpClient.Response> executeAsync(HttpClient.Request request) {
            LettuceAssert.notNull((Object)request, "Request must not be null");
            if (request.getMethod() != HttpClient.Method.GET) {
                CompletableFuture<HttpClient.Response> future = new CompletableFuture<HttpClient.Response>();
                future.completeExceptionally(new UnsupportedOperationException("Only GET method is currently supported"));
                return future;
            }
            if (!this.channel.isActive()) {
                CompletableFuture<HttpClient.Response> future = new CompletableFuture<HttpClient.Response>();
                future.completeExceptionally(new IOException("Connection is not active"));
                return future;
            }
            CompletableFuture<HttpClient.Response> responseFuture = new CompletableFuture<HttpClient.Response>();
            DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, request.getUri());
            this.setHostHeader((FullHttpRequest)nettyRequest, this.baseUri);
            nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            Map<String, String> headers = request.getHeaders();
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    nettyRequest.headers().set(header.getKey(), (Object)header.getValue());
                }
            }
            this.sequentialHandler.sendRequest(this.channel, (FullHttpRequest)nettyRequest, responseFuture);
            return responseFuture;
        }

        private void setHostHeader(FullHttpRequest nettyRequest, URI baseUri) {
            int port = baseUri.getPort();
            String hostHeader = port == -1 || port == this.getDefaultPort() ? baseUri.getHost() : baseUri.getHost() + ":" + port;
            nettyRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostHeader);
        }

        private int getDefaultPort() {
            boolean isHttps = "https".equalsIgnoreCase(this.baseUri.getScheme());
            return isHttps ? 443 : 80;
        }

        @Override
        public boolean isActive() {
            return this.channel != null && this.channel.isActive();
        }

        @Override
        public void close() {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().awaitUninterruptibly();
            }
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            if (this.channel != null && this.channel.isOpen()) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                    if (f.isSuccess()) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally(f.cause());
                    }
                }));
                return future;
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private static class HttpConnectionInitializer
    extends ChannelInitializer<SocketChannel> {
        private final URI uri;
        private final boolean isHttps;
        private final SslContext sslContext;
        private final int readTimeoutMs;

        HttpConnectionInitializer(URI uri, boolean isHttps, SslContext sslContext, int readTimeoutMs) {
            this.uri = uri;
            this.isHttps = isHttps;
            this.sslContext = sslContext;
            this.readTimeoutMs = readTimeoutMs;
        }

        protected void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.isHttps && this.sslContext == null) {
                throw new IllegalStateException("SSL context must be provided for HTTPS");
            }
            if (this.isHttps) {
                int port = this.uri.getPort() != -1 ? this.uri.getPort() : 443;
                pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(ch.alloc(), this.uri.getHost(), port)});
            }
            pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
            pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)this.readTimeoutMs, TimeUnit.MILLISECONDS)});
        }
    }
}

