/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.support.http.HttpClient;
import io.lettuce.core.support.http.HttpClientProvider;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ServiceLoader;

@Experimental
public class HttpClientResources {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpClientResources.class);

    private HttpClientResources() {
    }

    private static HttpClientProvider discoverProvider() {
        Object selectedProvider = null;
        int highestPriority = Integer.MIN_VALUE;
        ServiceLoader<HttpClientProvider> loader = ServiceLoader.load(HttpClientProvider.class);
        for (HttpClientProvider p : loader) {
            if (!p.isAvailable() || p.getPriority() <= highestPriority) continue;
            selectedProvider = p;
            highestPriority = p.getPriority();
            logger.debug("Found HTTP client provider: {} with priority {}", (Object)p.getClass().getName(), (Object)p.getPriority());
        }
        if (selectedProvider == null) {
            throw new IllegalStateException("No HTTP client provider available");
        }
        logger.debug("Using HTTP client provider: {}", (Object)selectedProvider.getClass().getName());
        return selectedProvider;
    }

    public static HttpClient get() {
        return ClientHolder.INSTANCE;
    }

    private static class ClientHolder {
        static final HttpClient INSTANCE = ClientHolder.createClient();

        private ClientHolder() {
        }

        private static HttpClient createClient() {
            logger.debug("Creating shared HTTP client");
            HttpClientProvider provider = HttpClientResources.discoverProvider();
            HttpClient client = provider.createHttpClient();
            logger.debug("Shared HTTP client created using provider: {}", (Object)provider.getClass().getName());
            return client;
        }
    }
}

