/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.SslOptions;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.AsyncCloseable;
import io.lettuce.core.support.http.DefaultConnectionConfig;
import io.lettuce.core.support.http.DefaultRequestBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Experimental
public interface HttpClient
extends Closeable {
    public HttpConnection connect(URI var1, ConnectionConfig var2) throws IOException;

    public CompletableFuture<HttpConnection> connectAsync(URI var1, ConnectionConfig var2);

    public void shutdown();

    public void shutdown(long var1, long var3, TimeUnit var5);

    public static interface Request {
        public Method getMethod();

        public String getPath();

        public Map<String, String> getQueryParams();

        public Map<String, String> getHeaders();

        public String getUri();

        public static RequestBuilder get(String path) {
            return DefaultRequestBuilder.get(path);
        }

        public static interface RequestBuilder {
            public RequestBuilder queryParam(String var1, String var2);

            public RequestBuilder queryParams(Map<String, String> var1);

            public RequestBuilder header(String var1, String var2);

            public RequestBuilder headers(Map<String, String> var1);

            public Request build();
        }
    }

    public static enum Method {
        GET;

    }

    public static interface ConnectionConfig {
        public int getConnectionTimeout();

        public int getReadTimeout();

        public SslOptions getSslOptions();

        public static Builder builder() {
            return new DefaultConnectionConfig.Builder();
        }

        public static ConnectionConfig defaults() {
            return DefaultConnectionConfig.DEFAULTS;
        }

        public static interface Builder {
            public Builder connectionTimeout(int var1);

            public Builder readTimeout(int var1);

            public Builder sslOptions(SslOptions var1);

            public ConnectionConfig build();
        }
    }

    public static interface Response {
        public int getStatusCode();

        public String getResponseBody(Charset var1);

        public String getHeader(CharSequence var1);
    }

    public static interface HttpConnection
    extends Closeable,
    AsyncCloseable {
        public Response execute(Request var1) throws IOException;

        public CompletableFuture<Response> executeAsync(Request var1);

        public boolean isActive();

        @Override
        public void close();

        @Override
        public CompletableFuture<Void> closeAsync();
    }
}

