/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.http.HttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class DefaultRequestBuilder
implements HttpClient.Request.RequestBuilder {
    private final HttpClient.Method method;
    private final String path;
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    DefaultRequestBuilder(HttpClient.Method method, String path) {
        LettuceAssert.notNull((Object)method, "Method must not be null");
        LettuceAssert.notNull((Object)path, "Path must not be null");
        this.method = method;
        this.path = path;
    }

    public static DefaultRequestBuilder get(String path) {
        return new DefaultRequestBuilder(HttpClient.Method.GET, path);
    }

    @Override
    public HttpClient.Request.RequestBuilder queryParam(String name, String value) {
        LettuceAssert.notNull((Object)name, "Query parameter name must not be null");
        LettuceAssert.notNull((Object)value, "Query parameter value must not be null");
        this.queryParams.put(name, value);
        return this;
    }

    @Override
    public HttpClient.Request.RequestBuilder queryParams(Map<String, String> params) {
        LettuceAssert.notNull(params, "Query parameters must not be null");
        this.queryParams.putAll(params);
        return this;
    }

    @Override
    public HttpClient.Request.RequestBuilder header(String name, String value) {
        LettuceAssert.notNull((Object)name, "Header name must not be null");
        LettuceAssert.notNull((Object)value, "Header value must not be null");
        this.headers.put(name, value);
        return this;
    }

    @Override
    public HttpClient.Request.RequestBuilder headers(Map<String, String> headers) {
        LettuceAssert.notNull(headers, "Headers must not be null");
        this.headers.putAll(headers);
        return this;
    }

    @Override
    public HttpClient.Request build() {
        return new DefaultRequest(this.method, this.path, this.queryParams, this.headers);
    }

    private static class DefaultRequest
    implements HttpClient.Request {
        private final HttpClient.Method method;
        private final String path;
        private final Map<String, String> queryParams;
        private final Map<String, String> headers;
        private final String uri;

        DefaultRequest(HttpClient.Method method, String path, Map<String, String> queryParams, Map<String, String> headers) {
            this.method = method;
            this.path = path;
            this.queryParams = Collections.unmodifiableMap(new LinkedHashMap<String, String>(queryParams));
            this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, String>(headers));
            this.uri = DefaultRequest.buildUri(path, queryParams);
        }

        @Override
        public HttpClient.Method getMethod() {
            return this.method;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        private static String buildUri(String path, Map<String, String> queryParams) {
            if (queryParams.isEmpty()) {
                return path;
            }
            StringBuilder uri = new StringBuilder(path);
            uri.append('?');
            boolean first = true;
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                if (!first) {
                    uri.append('&');
                }
                uri.append(DefaultRequest.urlEncode(entry.getKey()));
                uri.append('=');
                uri.append(DefaultRequest.urlEncode(entry.getValue()));
                first = false;
            }
            return uri.toString();
        }

        private static String urlEncode(String value) {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding not supported", e);
            }
        }
    }
}

