/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support.http;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.http.HttpClient;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DefaultHttpResponse
implements HttpClient.Response {
    private final int statusCode;
    private final ByteBuffer body;
    private final Map<String, String> headers;

    DefaultHttpResponse(int statusCode, ByteBuffer body, Map<String, String> headers) {
        LettuceAssert.notNull((Object)body, "Body must not be null");
        LettuceAssert.notNull(headers, "Headers must not be null");
        this.statusCode = statusCode;
        this.body = body.asReadOnlyBuffer();
        this.headers = Collections.unmodifiableMap(new HashMap<String, String>(headers));
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getResponseBody(Charset charset) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        ByteBuffer duplicate = this.body.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return new String(bytes, charset);
    }

    @Override
    public String getHeader(CharSequence name) {
        LettuceAssert.notNull((Object)name, "Header name must not be null");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name.toString())) continue;
            return entry.getValue();
        }
        return null;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private int statusCode;
        private ByteBuffer body;
        private Map<String, String> headers = Collections.emptyMap();

        Builder() {
        }

        Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        Builder body(ByteBuffer body) {
            this.body = body;
            return this;
        }

        Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        DefaultHttpResponse build() {
            return new DefaultHttpResponse(this.statusCode, this.body, this.headers);
        }
    }
}

