/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.FieldArgs;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class VectorFieldArgs<K>
extends FieldArgs<K> {
    private Optional<Algorithm> algorithm = Optional.empty();
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    @Override
    public String getFieldType() {
        return "VECTOR";
    }

    public Optional<Algorithm> getAlgorithm() {
        return this.algorithm;
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    @Override
    protected void buildTypeSpecificArgs(CommandArgs<K, ?> args) {
        this.algorithm.ifPresent(alg -> args.add(alg.toString()));
        if (!this.attributes.isEmpty()) {
            args.add(String.valueOf(this.attributes.size() * 2));
            this.attributes.forEach((key, value) -> {
                args.add((String)key);
                args.add(value.toString());
            });
        }
    }

    public static class Builder<K>
    extends FieldArgs.Builder<K, VectorFieldArgs<K>, Builder<K>> {
        public Builder() {
            super(new VectorFieldArgs());
        }

        public Builder<K> algorithm(Algorithm algorithm) {
            ((VectorFieldArgs)this.instance).algorithm = Optional.of(algorithm);
            return (Builder)this.self();
        }

        public Builder<K> flat() {
            return this.algorithm(Algorithm.FLAT);
        }

        public Builder<K> hnsw() {
            return this.algorithm(Algorithm.HNSW);
        }

        public Builder<K> svsVamana() {
            return this.algorithm(Algorithm.SVS_VAMANA);
        }

        public Builder<K> type(VectorType type) {
            ((VectorFieldArgs)this.instance).attributes.put(CommandKeyword.TYPE.toString(), type.toString());
            return (Builder)this.self();
        }

        public Builder<K> dimensions(int dimensions) {
            ((VectorFieldArgs)this.instance).attributes.put(CommandKeyword.DIM.toString(), dimensions);
            return (Builder)this.self();
        }

        public Builder<K> distanceMetric(DistanceMetric metric) {
            ((VectorFieldArgs)this.instance).attributes.put(CommandKeyword.DISTANCE_METRIC.toString(), metric.toString());
            return (Builder)this.self();
        }

        public Builder<K> attribute(String name, Object value) {
            ((VectorFieldArgs)this.instance).attributes.put(name, value);
            return (Builder)this.self();
        }
    }

    public static enum DistanceMetric {
        L2,
        COSINE,
        IP;

    }

    public static enum VectorType {
        BFLOAT16,
        FLOAT16,
        FLOAT32,
        FLOAT64,
        INT8,
        UINT8;

    }

    public static enum Algorithm {
        FLAT,
        HNSW,
        SVS_VAMANA("SVS-VAMANA");

        private final String redisName;

        private Algorithm() {
            this.redisName = this.name();
        }

        private Algorithm(String redisName) {
            this.redisName = redisName;
        }

        public String toString() {
            return this.redisName;
        }
    }
}

