/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EventLoopResources;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

class NioProvider {
    NioProvider() {
    }

    public static EventLoopResources getResources() {
        return NioResources.INSTANCE;
    }

    static enum NioResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(NioEventLoopGroup.class) || type.equals(MultiThreadIoEventLoopGroup.class);
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return MultiThreadIoEventLoopGroup.class;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            return new MultiThreadIoEventLoopGroup(nThreads, threadFactory, NioIoHandler.newFactory());
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            return NioSocketChannel.class;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            throw new UnsupportedOperationException("Domain sockets are not supported with NIO transport");
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            return NioDatagramChannel.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            throw new UnsupportedOperationException("Domain sockets are not supported with NIO transport");
        }
    }
}

