/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.HotkeysReply;
import io.lettuce.core.Range;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Experimental
public class HotkeysReplyParser
implements ComplexDataParser<HotkeysReply> {
    public static final HotkeysReplyParser INSTANCE = new HotkeysReplyParser();

    private HotkeysReplyParser() {
    }

    @Override
    public HotkeysReply parse(ComplexData dynamicData) {
        if (dynamicData == null) {
            return null;
        }
        Map<Object, Object> data = this.extractDataMap(dynamicData);
        if (data == null || data.isEmpty()) {
            return null;
        }
        boolean trackingActive = this.getLongValue(data, "tracking-active") == 1L;
        int sampleRatio = this.getLongValue(data, "sample-ratio").intValue();
        List<Range<Integer>> selectedSlots = this.parseSlotRanges(data.get("selected-slots"));
        Long sampledCommandSelectedSlotsUs = this.getLongValueOrNull(data, "sampled-command-selected-slots-us");
        Long allCommandsSelectedSlotsUs = this.getLongValueOrNull(data, "all-commands-selected-slots-us");
        Long allCommandsAllSlotsUs = this.getLongValueOrNull(data, "all-commands-all-slots-us");
        Long netBytesSampledCommandsSelectedSlots = this.getLongValueOrNull(data, "net-bytes-sampled-commands-selected-slots");
        Long netBytesAllCommandsSelectedSlots = this.getLongValueOrNull(data, "net-bytes-all-commands-selected-slots");
        Long netBytesAllCommandsAllSlots = this.getLongValueOrNull(data, "net-bytes-all-commands-all-slots");
        Long collectionStartTimeUnixMs = this.getLongValueOrNull(data, "collection-start-time-unix-ms");
        Long collectionDurationMs = this.getLongValueOrNull(data, "collection-duration-ms");
        Long totalCpuTimeUserMs = this.getLongValueOrNull(data, "total-cpu-time-user-ms");
        Long totalCpuTimeSysMs = this.getLongValueOrNull(data, "total-cpu-time-sys-ms");
        Long totalNetBytes = this.getLongValueOrNull(data, "total-net-bytes");
        Map<String, Long> byCpuTimeUs = this.parseKeyValueMap(data.get("by-cpu-time-us"));
        Map<String, Long> byNetBytes = this.parseKeyValueMap(data.get("by-net-bytes"));
        return new HotkeysReply(trackingActive, sampleRatio, selectedSlots, sampledCommandSelectedSlotsUs, allCommandsSelectedSlotsUs, allCommandsAllSlotsUs, netBytesSampledCommandsSelectedSlots, netBytesAllCommandsSelectedSlots, netBytesAllCommandsAllSlots, collectionStartTimeUnixMs, collectionDurationMs, totalCpuTimeUserMs, totalCpuTimeSysMs, totalNetBytes, byCpuTimeUs, byNetBytes);
    }

    private Map<Object, Object> extractDataMap(ComplexData dynamicData) {
        if (dynamicData.isMap()) {
            return dynamicData.getDynamicMap();
        }
        if (dynamicData.isList()) {
            List<Object> list = dynamicData.getDynamicList();
            if (list == null || list.isEmpty()) {
                return null;
            }
            if (list.size() == 1 && list.get(0) instanceof ComplexData) {
                ComplexData innerData = (ComplexData)list.get(0);
                if (innerData.isMap()) {
                    return innerData.getDynamicMap();
                }
                if (innerData.isList() && ((list = innerData.getDynamicList()) == null || list.isEmpty())) {
                    return null;
                }
            }
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < list.size(); i += 2) {
                if (i + 1 >= list.size()) continue;
                result.put(list.get(i), list.get(i + 1));
            }
            return result;
        }
        return null;
    }

    private Long getLongValue(Map<Object, Object> data, String key) {
        Object value = data.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Failed while parsing HOTKEYS GET: missing required field '" + key + "'");
        }
        return (Long)value;
    }

    private Long getLongValueOrNull(Map<Object, Object> data, String key) {
        Object value = data.get(key);
        return value != null ? (Long)value : null;
    }

    private List<Range<Integer>> parseSlotRanges(Object value) {
        if (value == null) {
            return new ArrayList<Range<Integer>>();
        }
        if (value instanceof ComplexData) {
            List<Object> list = ((ComplexData)value).getDynamicList();
            ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>(list.size());
            for (Object item : list) {
                List<Object> range;
                if (!(item instanceof ComplexData) || (range = ((ComplexData)item).getDynamicList()).size() != 2) continue;
                int start = ((Long)range.get(0)).intValue();
                int end = ((Long)range.get(1)).intValue();
                result.add(Range.create(start, end));
            }
            return result;
        }
        return new ArrayList<Range<Integer>>();
    }

    private Map<String, Long> parseKeyValueMap(Object value) {
        if (value == null) {
            return new LinkedHashMap<String, Long>();
        }
        if (value instanceof ComplexData) {
            ComplexData complexData = (ComplexData)value;
            LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
            if (complexData.isMap()) {
                Map<Object, Object> map = complexData.getDynamicMap();
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    result.put((String)entry.getKey(), (Long)entry.getValue());
                }
            } else {
                List<Object> list = complexData.getDynamicList();
                for (int i = 0; i < list.size(); i += 2) {
                    String key = (String)list.get(i);
                    Long val = (Long)list.get(i + 1);
                    result.put(key, val);
                }
            }
            return result;
        }
        return new LinkedHashMap<String, Long>();
    }
}

