/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.annotations.Experimental;

@Experimental
public class RedisRestException
extends RuntimeException {
    private final int statusCode;
    private final String responseBody;

    public RedisRestException(String message, int statusCode, String responseBody) {
        super(message);
        this.statusCode = statusCode;
        this.responseBody = responseBody;
    }

    public RedisRestException(String message, Throwable cause) {
        super(message, cause);
        this.statusCode = -1;
        this.responseBody = null;
    }

    public RedisRestException(String message) {
        super(message);
        this.statusCode = -1;
        this.responseBody = null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String toString() {
        if (this.statusCode > 0) {
            return super.toString() + " [HTTP " + this.statusCode + "]";
        }
        return super.toString();
    }
}

