/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.failover.api.RawConnectionFactory;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthCheckStrategySupplier;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.ProbingPolicy;

@Experimental
public class PingStrategy
implements HealthCheckStrategy {
    private final RawConnectionFactory connectionFactory;
    private final HealthCheckStrategy.Config config;
    public static final HealthCheckStrategySupplier DEFAULT = (uri, connectionFactory) -> new PingStrategy(connectionFactory);

    public PingStrategy(RawConnectionFactory connectionFactory) {
        this(connectionFactory, HealthCheckStrategy.Config.create());
    }

    public PingStrategy(RawConnectionFactory connectionFactory, HealthCheckStrategy.Config config) {
        this.connectionFactory = connectionFactory;
        this.config = config;
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public int getTimeout() {
        return this.config.getTimeout();
    }

    @Override
    public int getNumProbes() {
        return this.config.getNumProbes();
    }

    @Override
    public ProbingPolicy getPolicy() {
        return this.config.getPolicy();
    }

    @Override
    public int getDelayInBetweenProbes() {
        return this.config.getDelayInBetweenProbes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HealthStatus doHealthCheck(RedisURI endpoint) {
        try (StatefulRedisConnection<?, ?> connection = this.connectionFactory.create(endpoint);){
            if (connection == null) {
                HealthStatus healthStatus2 = HealthStatus.UNHEALTHY;
                return healthStatus2;
            }
            HealthStatus healthStatus = "PONG".equals(connection.sync().ping()) ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
            return healthStatus;
        }
        catch (Exception e) {
            return HealthStatus.UNHEALTHY;
        }
    }

    @Override
    public void close() {
    }
}

