/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.ProbingPolicy;
import io.lettuce.core.failover.health.RedisRestClient;
import io.lettuce.core.failover.health.RedisRestException;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.http.HttpClient;
import io.lettuce.core.support.http.HttpClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

@Experimental
public class LagAwareStrategy
implements HealthCheckStrategy {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(LagAwareStrategy.class);
    private final Config config;
    private final RedisRestClient redisRestClient;
    private final HttpClient httpClient;
    private Long cachedBdbId;

    public LagAwareStrategy(Config config) {
        this(config, null);
    }

    public LagAwareStrategy(Config config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient != null ? httpClient : HttpClientResources.get();
        this.redisRestClient = this.createRedisRestClient(config, this.httpClient);
    }

    @Override
    public int getInterval() {
        return this.config.interval;
    }

    @Override
    public int getTimeout() {
        return this.config.timeout;
    }

    @Override
    public int getNumProbes() {
        return this.config.getNumProbes();
    }

    @Override
    public ProbingPolicy getPolicy() {
        return this.config.getPolicy();
    }

    @Override
    public int getDelayInBetweenProbes() {
        return this.config.getDelayInBetweenProbes();
    }

    @Override
    public HealthStatus doHealthCheck(RedisURI endpoint) {
        try {
            Long bdbId = this.cachedBdbId;
            if (bdbId == null) {
                String dbHost = endpoint.getHost();
                List<RedisRestClient.BdbInfo> bdbs = this.redisRestClient.getBdbs();
                RedisRestClient.BdbInfo matchingBdb = bdbs.stream().filter(bdb -> bdb.matches(dbHost)).findFirst().orElse(null);
                if (matchingBdb == null) {
                    String msg = String.format("No BDB found matching host '%s' for health check", dbHost);
                    log.warn(msg);
                    throw new RedisException(msg);
                }
                bdbId = matchingBdb.getUid();
                log.debug("Found matching BDB '{}' for host '{}'", (Object)bdbId, (Object)dbHost);
                this.cachedBdbId = bdbId;
            }
            if (this.config.isExtendedCheckEnabled() ? this.redisRestClient.checkBdbAvailability(bdbId, true, this.config.getAvailabilityLagTolerance().toMillis()) : this.redisRestClient.checkBdbAvailability(bdbId, false)) {
                return HealthStatus.HEALTHY;
            }
        }
        catch (RedisRestException e) {
            this.cachedBdbId = null;
            log.debug("Redis REST call failed", (Throwable)e);
            return HealthStatus.UNHEALTHY;
        }
        return HealthStatus.UNHEALTHY;
    }

    @Override
    public void close() {
        if (this.redisRestClient != null) {
            this.redisRestClient.close();
        }
    }

    RedisRestClient createRedisRestClient(Config config, HttpClient httpClient) {
        return new RedisRestClient(config.getRestEndpoint(), config.getCredentialsSupplier(), config.getTimeout(), config.getSslOptions(), this.httpClient);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class Config
    extends HealthCheckStrategy.Config {
        public static final boolean EXTENDED_CHECK_DEFAULT = true;
        public static final Duration AVAILABILITY_LAG_TOLERANCE_DEFAULT = Duration.ofMillis(5000L);
        private final URI restEndpoint;
        private final Supplier<RedisCredentials> credentialsSupplier;
        private final SslOptions sslOptions;
        private final Duration availabilityLagTolerance;
        private final boolean extendedCheckEnabled;

        public Config(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            this(Config.builder(restEndpoint, credentialsSupplier).availabilityLagTolerance(AVAILABILITY_LAG_TOLERANCE_DEFAULT).extendedCheckEnabled(true));
        }

        private Config(Builder builder) {
            super(builder);
            this.restEndpoint = builder.restEndpoint;
            this.credentialsSupplier = builder.credentialsSupplier;
            this.sslOptions = builder.sslOptions;
            this.availabilityLagTolerance = builder.availabilityLagTolerance;
            this.extendedCheckEnabled = builder.extendedCheckEnabled;
        }

        public URI getRestEndpoint() {
            return this.restEndpoint;
        }

        public Supplier<RedisCredentials> getCredentialsSupplier() {
            return this.credentialsSupplier;
        }

        public SslOptions getSslOptions() {
            return this.sslOptions;
        }

        public Duration getAvailabilityLagTolerance() {
            return this.availabilityLagTolerance;
        }

        public boolean isExtendedCheckEnabled() {
            return this.extendedCheckEnabled;
        }

        public static Builder builder(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return Config.builder().restEndpoint(restEndpoint).credentialsSupplier(credentialsSupplier);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Config create(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return Config.builder(restEndpoint, credentialsSupplier).build();
        }

        public static Config databaseAvailability(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return Config.builder(restEndpoint, credentialsSupplier).extendedCheckEnabled(false).build();
        }

        public static Config lagAware(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return Config.builder(restEndpoint, credentialsSupplier).extendedCheckEnabled(true).build();
        }

        public static Config lagAwareWithTolerance(URI restEndpoint, Supplier<RedisCredentials> credentialsSupplier, Duration availabilityLagTolerance) {
            return Config.builder(restEndpoint, credentialsSupplier).extendedCheckEnabled(true).availabilityLagTolerance(availabilityLagTolerance).build();
        }

        public static class Builder
        extends HealthCheckStrategy.Config.Builder<Builder, Config> {
            private URI restEndpoint;
            private Supplier<RedisCredentials> credentialsSupplier;
            private SslOptions sslOptions;
            private Duration availabilityLagTolerance = AVAILABILITY_LAG_TOLERANCE_DEFAULT;
            private boolean extendedCheckEnabled = true;

            private Builder() {
            }

            public Builder restEndpoint(URI restEndpoint) {
                LettuceAssert.notNull((Object)restEndpoint, "Redis Enterprise REST API endpoint must not be null");
                this.restEndpoint = restEndpoint;
                return this;
            }

            public Builder credentialsSupplier(Supplier<RedisCredentials> credentialsSupplier) {
                LettuceAssert.notNull(credentialsSupplier, "Credentials supplier must not be null");
                this.credentialsSupplier = credentialsSupplier;
                return this;
            }

            public Builder sslOptions(SslOptions sslOptions) {
                LettuceAssert.notNull((Object)sslOptions, "SSL options must not be null");
                this.sslOptions = sslOptions;
                return this;
            }

            public Builder availabilityLagTolerance(Duration availabilityLagTolerance) {
                LettuceAssert.notNull((Object)availabilityLagTolerance, "Availability lag tolerance must not be null");
                LettuceAssert.isTrue(availabilityLagTolerance.toMillis() > 0L, "Availability lag tolerance must be greater than zero");
                this.availabilityLagTolerance = availabilityLagTolerance;
                return this;
            }

            public Builder extendedCheckEnabled(boolean extendedCheckEnabled) {
                this.extendedCheckEnabled = extendedCheckEnabled;
                return this;
            }

            @Override
            public Config build() {
                LettuceAssert.notNull((Object)this.restEndpoint, "Redis Enterprise REST API endpoint must not be null");
                return new Config(this);
            }
        }
    }
}

