/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.ProbingPolicy;

@Experimental
public class AbstractHealthCheckStrategy
implements HealthCheckStrategy {
    private final HealthCheckStrategy.Config config;

    public AbstractHealthCheckStrategy(HealthCheckStrategy.Config config) {
        this.config = config;
    }

    @Override
    public HealthStatus doHealthCheck(RedisURI endpoint) {
        return HealthStatus.HEALTHY;
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public int getTimeout() {
        return this.config.getTimeout();
    }

    @Override
    public int getNumProbes() {
        return this.config.getNumProbes();
    }

    @Override
    public int getDelayInBetweenProbes() {
        return this.config.getDelayInBetweenProbes();
    }

    @Override
    public ProbingPolicy getPolicy() {
        return this.config.getPolicy();
    }
}

