/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.event;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.event.Event;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.event.SwitchReason;

@Experimental
public class DatabaseSwitchEvent
implements Event {
    private final SwitchReason reason;
    private final RedisURI fromDb;
    private final RedisURI toDb;
    private final StatefulRedisMultiDbConnection<?, ?> source;

    public DatabaseSwitchEvent(SwitchReason reason, RedisURI fromDb, RedisURI toDb, StatefulRedisMultiDbConnection<?, ?> source) {
        this.reason = reason;
        this.fromDb = fromDb;
        this.toDb = toDb;
        this.source = source;
    }

    public SwitchReason getReason() {
        return this.reason;
    }

    public RedisURI getFromDb() {
        return this.fromDb;
    }

    public RedisURI getToDb() {
        return this.toDb;
    }

    public StatefulRedisMultiDbConnection<?, ?> getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [reason=").append((Object)this.reason);
        sb.append(", fromDb=").append(this.fromDb);
        sb.append(", toDb=").append(this.toDb);
        sb.append(", source=").append(this.source);
        sb.append("]");
        return sb.toString();
    }
}

