/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.event;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.event.Event;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import java.util.Collections;
import java.util.List;

@Experimental
public class AllDatabasesUnhealthyEvent
implements Event {
    private final int failedAttempts;
    private final List<RedisURI> unhealthyDatabases;
    private final StatefulRedisMultiDbConnection<?, ?> source;

    public AllDatabasesUnhealthyEvent(int failedAttempts, List<RedisURI> unhealthyDatabases, StatefulRedisMultiDbConnection<?, ?> source) {
        this.failedAttempts = failedAttempts;
        this.unhealthyDatabases = unhealthyDatabases != null ? Collections.unmodifiableList(unhealthyDatabases) : Collections.emptyList();
        this.source = source;
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public List<RedisURI> getUnhealthyDatabases() {
        return this.unhealthyDatabases;
    }

    public StatefulRedisMultiDbConnection<?, ?> getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [failedAttempts=").append(this.failedAttempts);
        sb.append(", unhealthyDatabases=").append(this.unhealthyDatabases);
        sb.append(", source=").append(this.source);
        sb.append("]");
        return sb.toString();
    }
}

