/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.api;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.api.InitializationPolicy;
import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;

@Experimental
public class MultiDbOptions {
    private final boolean failbackSupported;
    private final Duration failbackCheckInterval;
    private final Duration gracePeriod;
    private final InitializationPolicy initializationPolicy;
    private final Duration delayInBetweenFailoverAttempts;

    private MultiDbOptions(Builder builder) {
        this.failbackSupported = builder.failbackSupported;
        this.failbackCheckInterval = builder.failbackCheckInterval;
        this.gracePeriod = builder.gracePeriod;
        this.initializationPolicy = builder.initializationPolicy;
        this.delayInBetweenFailoverAttempts = builder.delayInBetweenFailoverAttempts;
    }

    public boolean isFailbackSupported() {
        return this.failbackSupported;
    }

    public Duration getFailbackCheckInterval() {
        return this.failbackCheckInterval;
    }

    public InitializationPolicy getInitializationPolicy() {
        return this.initializationPolicy;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    public Duration getDelayInBetweenFailoverAttempts() {
        return this.delayInBetweenFailoverAttempts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MultiDbOptions create() {
        return MultiDbOptions.builder().build();
    }

    public static class Builder {
        private static final Duration FAILBACK_CHECK_INTERVAL_DEFAULT = Duration.ofSeconds(120L);
        private static final Duration MAX_INTERVAL = Duration.ofMillis(Long.MAX_VALUE);
        private static final Duration GRACE_PERIOD_DEFAULT = Duration.ofSeconds(60L);
        private static final Duration DELAY_IN_BETWEEN_FAILOVER_ATTEMPTS_DEFAULT = Duration.ofSeconds(12L);
        private boolean failbackSupported = true;
        private Duration failbackCheckInterval = FAILBACK_CHECK_INTERVAL_DEFAULT;
        private Duration gracePeriod = GRACE_PERIOD_DEFAULT;
        private InitializationPolicy initializationPolicy = InitializationPolicy.BuiltIn.MAJORITY_AVAILABLE;
        private Duration delayInBetweenFailoverAttempts = DELAY_IN_BETWEEN_FAILOVER_ATTEMPTS_DEFAULT;

        private Builder() {
        }

        public Builder failbackSupported(boolean failbackSupported) {
            this.failbackSupported = failbackSupported;
            return this;
        }

        public Builder failbackCheckInterval(Duration failbackCheckInterval) {
            LettuceAssert.isTrue(failbackCheckInterval.compareTo(MAX_INTERVAL) <= 0, "failbackCheckInterval must be less than max value of long in milliseconds.");
            LettuceAssert.isTrue(failbackCheckInterval.toMillis() > 0L, "failbackCheckInterval must be greater than 0, got: " + failbackCheckInterval);
            this.failbackCheckInterval = failbackCheckInterval;
            return this;
        }

        public Builder gracePeriod(Duration gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        public Builder delayInBetweenFailoverAttempts(Duration delayInBetweenFailoverAttempts) {
            LettuceAssert.notNull((Object)delayInBetweenFailoverAttempts, "delayInBetweenFailoverAttempts must not be null");
            LettuceAssert.isTrue(delayInBetweenFailoverAttempts.compareTo(MAX_INTERVAL) <= 0, "delayInBetweenFailoverAttempts must be less than max value of long in milliseconds.");
            LettuceAssert.isTrue(delayInBetweenFailoverAttempts.toMillis() > 0L, "delayInBetweenFailoverAttempts must be greater than 0, got: " + delayInBetweenFailoverAttempts);
            this.delayInBetweenFailoverAttempts = delayInBetweenFailoverAttempts;
            return this;
        }

        public Builder initializationPolicy(InitializationPolicy initializationPolicy) {
            LettuceAssert.notNull((Object)initializationPolicy, "initializationPolicy must not be null");
            this.initializationPolicy = initializationPolicy;
            return this;
        }

        public MultiDbOptions build() {
            return new MultiDbOptions(this);
        }
    }
}

