/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.api;

import io.lettuce.core.annotations.Experimental;

@Experimental
public interface InitializationPolicy {
    public Decision evaluate(InitializationContext var1);

    public static class BuiltIn {
        public static final InitializationPolicy ALL_AVAILABLE = new AllAvailablePolicy();
        public static final InitializationPolicy MAJORITY_AVAILABLE = new MajorityAvailablePolicy();
        public static final InitializationPolicy ONE_AVAILABLE = new OneAvailablePolicy();

        private static class OneAvailablePolicy
        implements InitializationPolicy {
            private OneAvailablePolicy() {
            }

            @Override
            public Decision evaluate(InitializationContext ctx) {
                if (ctx.getAvailableConnections() > 0) {
                    return Decision.SUCCESS;
                }
                if (ctx.getPendingConnections() == 0) {
                    return Decision.FAIL;
                }
                return Decision.CONTINUE;
            }
        }

        private static class MajorityAvailablePolicy
        implements InitializationPolicy {
            private MajorityAvailablePolicy() {
            }

            @Override
            public Decision evaluate(InitializationContext ctx) {
                int total = ctx.getPendingConnections() + ctx.getAvailableConnections() + ctx.getFailedConnections();
                int required = total / 2 + 1;
                if (ctx.getAvailableConnections() >= required) {
                    return Decision.SUCCESS;
                }
                int maxPossibleAvailable = ctx.getAvailableConnections() + ctx.getPendingConnections();
                if (maxPossibleAvailable < required) {
                    return Decision.FAIL;
                }
                if (ctx.getPendingConnections() == 0) {
                    return ctx.getAvailableConnections() >= required ? Decision.SUCCESS : Decision.FAIL;
                }
                return Decision.CONTINUE;
            }
        }

        private static class AllAvailablePolicy
        implements InitializationPolicy {
            private AllAvailablePolicy() {
            }

            @Override
            public Decision evaluate(InitializationContext ctx) {
                if (ctx.getFailedConnections() > 0) {
                    return Decision.FAIL;
                }
                if (ctx.getPendingConnections() == 0) {
                    return Decision.SUCCESS;
                }
                return Decision.CONTINUE;
            }
        }
    }

    public static interface InitializationContext {
        public int getAvailableConnections();

        public int getFailedConnections();

        public int getPendingConnections();
    }

    public static enum Decision {
        CONTINUE,
        SUCCESS,
        FAIL;

    }
}

