/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.api;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.CircuitBreaker;

@Experimental
public class CircuitBreakerStateChangeEvent {
    private final CircuitBreaker circuitBreaker;
    private final CircuitBreaker.State previousState;
    private final CircuitBreaker.State newState;
    private final long timestamp;

    public CircuitBreakerStateChangeEvent(CircuitBreaker circuitBreaker, CircuitBreaker.State previousState, CircuitBreaker.State newState) {
        this.circuitBreaker = circuitBreaker;
        this.previousState = previousState;
        this.newState = newState;
        this.timestamp = System.currentTimeMillis();
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public CircuitBreaker.State getPreviousState() {
        return this.previousState;
    }

    public CircuitBreaker.State getNewState() {
        return this.newState;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "CircuitBreakerStateChangeEvent{previousState=" + (Object)((Object)this.previousState) + ", newState=" + (Object)((Object)this.newState) + ", timestamp=" + this.timestamp + '}';
    }
}

