/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.HealthStatusChangeEvent;
import io.lettuce.core.failover.health.HealthStatusListener;
import io.lettuce.core.failover.health.HealthStatusManager;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.ClientResources;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class StatusTracker {
    private final HealthStatusManager healthStatusManager;
    private final ScheduledExecutorService scheduler;

    public StatusTracker(HealthStatusManager healthStatusManager, ClientResources clientResources) {
        LettuceAssert.notNull((Object)healthStatusManager, "HealthStatusManager must not be null");
        LettuceAssert.notNull((Object)clientResources, "ClientResources must not be null");
        this.healthStatusManager = healthStatusManager;
        this.scheduler = clientResources.eventExecutorGroup();
    }

    public CompletableFuture<HealthStatus> waitForHealthStatusAsync(final RedisURI endpoint) {
        LettuceAssert.notNull((Object)endpoint, "Endpoint must not be null");
        HealthStatus currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
        if (currentStatus != HealthStatus.UNKNOWN) {
            return CompletableFuture.completedFuture(currentStatus);
        }
        final CompletableFuture<HealthStatus> future = new CompletableFuture<HealthStatus>();
        final AtomicBoolean listenerRemoved = new AtomicBoolean(false);
        HealthStatusListener tempListener = new HealthStatusListener(){

            @Override
            public void onStatusChange(HealthStatusChangeEvent event) {
                if (event.getEndpoint().equals(endpoint) && event.getNewStatus() != HealthStatus.UNKNOWN && future.complete(event.getNewStatus()) && listenerRemoved.compareAndSet(false, true)) {
                    StatusTracker.this.healthStatusManager.unregisterListener(endpoint, this);
                }
            }
        };
        this.healthStatusManager.registerListener(endpoint, tempListener);
        currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
        if (currentStatus != HealthStatus.UNKNOWN) {
            if (listenerRemoved.compareAndSet(false, true)) {
                this.healthStatusManager.unregisterListener(endpoint, tempListener);
            }
            future.complete(currentStatus);
            return future;
        }
        long timeoutMs = this.healthStatusManager.getMaxWaitFor(endpoint);
        this.scheduler.schedule(() -> {
            if (future.completeExceptionally(new RedisConnectionException("Timeout while waiting for health check result for " + endpoint)) && listenerRemoved.compareAndSet(false, true)) {
                this.healthStatusManager.unregisterListener(endpoint, tempListener);
            }
        }, timeoutMs, TimeUnit.MILLISECONDS);
        future.whenComplete((status, throwable) -> {
            if (listenerRemoved.compareAndSet(false, true)) {
                this.healthStatusManager.unregisterListener(endpoint, tempListener);
            }
        });
        return future;
    }
}

