/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.api.AsyncCloseable;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.failover.api.DatabaseConfig;
import io.lettuce.core.failover.api.RedisDatabase;
import io.lettuce.core.failover.health.HealthCheck;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.metrics.MetricsSnapshot;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
class RedisDatabaseImpl<C extends StatefulRedisConnection<?, ?>>
implements RedisDatabase,
AsyncCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RedisDatabaseImpl.class);
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private final float weight;
    private final C connection;
    private final RedisURI redisURI;
    private final DatabaseEndpoint databaseEndpoint;
    private final CircuitBreaker circuitBreaker;
    private final HealthCheck healthCheck;
    private final String id;
    private final Clock clock;
    private volatile long gracePeriodEndTime = 0L;

    public RedisDatabaseImpl(DatabaseConfig config, C connection, DatabaseEndpoint databaseEndpoint, CircuitBreaker circuitBreaker, HealthCheck healthCheck) {
        this(config, connection, databaseEndpoint, circuitBreaker, healthCheck, Clock.systemUTC());
    }

    public RedisDatabaseImpl(DatabaseConfig config, C connection, DatabaseEndpoint databaseEndpoint, CircuitBreaker circuitBreaker, HealthCheck healthCheck, Clock clock) {
        this.id = config.getRedisURI().toString() + "-" + ID_COUNTER.getAndIncrement();
        this.redisURI = config.getRedisURI();
        this.weight = config.getWeight();
        this.connection = connection;
        this.databaseEndpoint = databaseEndpoint;
        this.circuitBreaker = circuitBreaker;
        this.healthCheck = healthCheck;
        this.clock = clock;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    C getConnection() {
        return this.connection;
    }

    @Override
    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    public DatabaseEndpoint getDatabaseEndpoint() {
        return this.databaseEndpoint;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletionStage closeFuture = this.connection.closeAsync().whenComplete((v, t) -> this.circuitBreaker.close());
        ((CompletableFuture)closeFuture).exceptionally(exc -> {
            logger.error("Error while closing database :", exc);
            return null;
        });
        return closeFuture;
    }

    @Override
    public MetricsSnapshot getMetricsSnapshot() {
        return this.circuitBreaker.getSnapshot();
    }

    @Override
    public HealthStatus getHealthCheckStatus() {
        return this.healthCheck != null ? this.healthCheck.getStatus() : HealthStatus.HEALTHY;
    }

    @Override
    public CircuitBreaker.State getCircuitBreakerState() {
        return this.circuitBreaker.getCurrentState();
    }

    @Override
    public boolean isHealthy() {
        return !this.isInGracePeriod() && this.getHealthCheckStatus().isHealthy() && this.getCircuitBreakerState().isClosed();
    }

    boolean isHealthyIgnoreGracePeriod() {
        return this.getHealthCheckStatus().isHealthy() && this.getCircuitBreakerState().isClosed();
    }

    void startGracePeriod(Duration durationMillis) {
        if (durationMillis.toMillis() > 0L) {
            long endTime = this.clock.millis() + durationMillis.toMillis();
            this.gracePeriodEndTime = endTime < 0L ? Long.MAX_VALUE : endTime;
            logger.info("Started grace period of {}ms for database {}", (Object)durationMillis, (Object)this.getId());
        }
    }

    boolean isInGracePeriod() {
        boolean inGracePeriod;
        long endTime = this.gracePeriodEndTime;
        if (endTime == 0L) {
            return false;
        }
        boolean bl = inGracePeriod = this.clock.millis() < endTime;
        if (!inGracePeriod) {
            this.clearGracePeriod();
            this.circuitBreaker.transitionTo(CircuitBreaker.State.CLOSED);
        }
        return inGracePeriod;
    }

    void clearGracePeriod() {
        this.gracePeriodEndTime = 0L;
    }
}

