/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.api.AsyncCloseable;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.failover.RedisDatabaseImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

class RedisDatabaseDeferredCompletion<SC extends StatefulRedisConnection<?, ?>>
implements AsyncCloseable {
    private final List<CompletableFuture<RedisDatabaseImpl<SC>>> databaseFutures;

    RedisDatabaseDeferredCompletion(List<CompletableFuture<RedisDatabaseImpl<SC>>> databaseFutures) {
        this.databaseFutures = databaseFutures;
    }

    CompletableFuture<RedisDatabaseImpl<SC>>[] whenComplete(BiConsumer<RedisDatabaseImpl<SC>, Throwable> action) {
        return (CompletableFuture[])this.databaseFutures.stream().map(f -> f.whenComplete(action)).toArray(CompletableFuture[]::new);
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.allOf((CompletableFuture[])this.databaseFutures.stream().map(f -> ((CompletableFuture)f.exceptionally(e -> null)).thenCompose(db -> {
            if (db != null) {
                return db.closeAsync();
            }
            return CompletableFuture.completedFuture(null);
        })).toArray(CompletableFuture[]::new));
    }
}

