/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.api.RawConnectionFactory;

class RawConnectionFactoryImpl
implements RawConnectionFactory {
    private final ClientOptions clientOptions;
    private final MultiDbClientImpl client;

    public RawConnectionFactoryImpl(ClientOptions clientOptions, MultiDbClientImpl client) {
        this.clientOptions = clientOptions;
        this.client = client;
    }

    @Override
    public StatefulRedisConnection<?, ?> create(RedisURI endpoint) {
        this.client.setOptions(this.clientOptions);
        try {
            StatefulRedisConnection<String, String> statefulRedisConnection = this.client.connect(endpoint);
            return statefulRedisConnection;
        }
        finally {
            this.client.resetOptions();
        }
    }
}

