/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.CircuitBreakerGeneration;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;

class MultiDbOutboundHandler
extends ChannelOutboundHandlerAdapter {
    public static final String HANDLER_NAME = MultiDbOutboundHandler.class.getSimpleName() + "#0";
    private CircuitBreaker circuitBreaker;

    public MultiDbOutboundHandler(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.circuitBreaker != null) {
            if (msg instanceof RedisCommand) {
                promise.addListener(this.recorder(this.circuitBreaker.getGeneration(), (RedisCommand)msg));
            }
            if (msg instanceof List) {
                List list = (List)msg;
                for (Object o : list) {
                    if (!(o instanceof RedisCommand)) continue;
                    promise.addListener(this.recorder(this.circuitBreaker.getGeneration(), (RedisCommand)o));
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    private GenericFutureListener<? extends Future<? super Void>> recorder(CircuitBreakerGeneration generation, RedisCommand<?, ?, ?> command) {
        return future -> {
            if (!future.isSuccess()) {
                generation.recordResult(future.cause());
            } else {
                this.recordOnCommandComplete(generation, command);
            }
        };
    }

    private void recordOnCommandComplete(CircuitBreakerGeneration generation, RedisCommand<?, ?, ?> command) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete((o, e) -> {
                if (!(e instanceof RedisCommandTimeoutException)) {
                    generation.recordResult((Throwable)e);
                }
            });
        }
    }
}

