/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.DatabaseEndpointImpl;
import io.lettuce.core.failover.DatabasePubSubEndpointImpl;
import io.lettuce.core.failover.MultiDbAsyncConnectionBuilder;
import io.lettuce.core.failover.MultiDbAsyncPubSubConnectionBuilder;
import io.lettuce.core.failover.MultiDbClient;
import io.lettuce.core.failover.api.DatabaseConfig;
import io.lettuce.core.failover.api.ImmutableRedisURI;
import io.lettuce.core.failover.api.MultiDbConnectionFuture;
import io.lettuce.core.failover.api.MultiDbOptions;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.api.StatefulRedisMultiDbPubSubConnection;
import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

class MultiDbClientImpl
extends RedisClient
implements MultiDbClient {
    private static final RedisURI EMPTY_URI = new ImmutableRedisURI(new RedisURI());
    private final Map<RedisURI, DatabaseConfig> databaseConfigMap;
    private final ThreadLocal<ClientOptions> localClientOptions = new ThreadLocal();
    private final MultiDbOptions multiDbOptions;

    MultiDbClientImpl(Collection<DatabaseConfig> databaseConfigs, MultiDbOptions multiDbOptions) {
        this(null, databaseConfigs, multiDbOptions);
    }

    MultiDbClientImpl(ClientResources clientResources, Collection<DatabaseConfig> databaseConfigs, MultiDbOptions multiDbOptions) {
        super(clientResources, EMPTY_URI);
        LettuceAssert.notNull(databaseConfigs, "DatabaseConfigs must not be null");
        LettuceAssert.noNullElements(databaseConfigs, "DatabaseConfigs must not contain null elements");
        LettuceAssert.notEmpty(databaseConfigs.toArray(), "DatabaseConfigs must not be empty");
        this.databaseConfigMap = new ConcurrentHashMap<RedisURI, DatabaseConfig>(databaseConfigs.size());
        for (DatabaseConfig config : databaseConfigs) {
            LettuceAssert.notNull((Object)config.getRedisURI(), "RedisURI must not be null");
            this.databaseConfigMap.put(config.getRedisURI(), config);
        }
        LettuceAssert.notNull((Object)multiDbOptions, "MultiDbOptions must not be null");
        this.multiDbOptions = multiDbOptions;
    }

    @Override
    public Collection<RedisURI> getRedisURIs() {
        return this.databaseConfigMap.keySet();
    }

    @Override
    public ClientOptions getOptions() {
        ClientOptions options = this.localClientOptions.get();
        if (options == null) {
            throw new IllegalStateException("ClientOptions not set!");
        }
        return options;
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        this.localClientOptions.set(clientOptions);
    }

    void resetOptions() {
        this.localClientOptions.remove();
    }

    @Override
    public MultiDbOptions getMultiDbOptions() {
        return this.multiDbOptions;
    }

    @Override
    public StatefulRedisMultiDbConnection<String, String> connect() {
        return this.connect((RedisCodec)this.newStringStringCodec());
    }

    @Override
    public <K, V> StatefulRedisMultiDbConnection<K, V> connect(RedisCodec<K, V> codec) {
        MultiDbConnectionFuture<StatefulRedisMultiDbConnection<K, V>> connectionFuture = this.connectAsync(codec);
        try {
            return (StatefulRedisMultiDbConnection)connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(e);
        }
        catch (Exception e) {
            throw RedisConnectionException.create(Exceptions.unwrap(e));
        }
    }

    @Override
    public MultiDbConnectionFuture<StatefulRedisMultiDbConnection<String, String>> connectAsync() {
        return this.connectAsync(this.newStringStringCodec());
    }

    @Override
    public <K, V> MultiDbConnectionFuture<StatefulRedisMultiDbConnection<K, V>> connectAsync(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "codec must not be null");
        MultiDbAsyncConnectionBuilder<K, V> builder = this.createConnectionBuilder(codec);
        CompletableFuture future = builder.connectAsync(this.databaseConfigMap);
        return MultiDbConnectionFuture.from(future);
    }

    protected <K, V> MultiDbAsyncConnectionBuilder<K, V> createConnectionBuilder(RedisCodec<K, V> codec) {
        return new MultiDbAsyncConnectionBuilder<K, V>(this, this.getResources(), codec, this.closeableResources, this.multiDbOptions);
    }

    @Override
    public StatefulRedisMultiDbPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub((RedisCodec)this.newStringStringCodec());
    }

    @Override
    public <K, V> StatefulRedisMultiDbPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        MultiDbConnectionFuture<StatefulRedisMultiDbPubSubConnection<K, V>> connectionFuture = this.connectPubSubAsync(codec);
        try {
            return (StatefulRedisMultiDbPubSubConnection)connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(e);
        }
        catch (Exception e) {
            throw RedisConnectionException.create(Exceptions.unwrap(e));
        }
    }

    @Override
    public MultiDbConnectionFuture<StatefulRedisMultiDbPubSubConnection<String, String>> connectPubSubAsync() {
        return this.connectPubSubAsync(this.newStringStringCodec());
    }

    @Override
    public <K, V> MultiDbConnectionFuture<StatefulRedisMultiDbPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "codec must not be null");
        MultiDbAsyncPubSubConnectionBuilder<K, V> builder = this.createPubSubConnectionBuilder(codec);
        CompletableFuture future = builder.connectAsync(this.databaseConfigMap);
        return MultiDbConnectionFuture.from(future);
    }

    protected <K, V> MultiDbAsyncPubSubConnectionBuilder<K, V> createPubSubConnectionBuilder(RedisCodec<K, V> codec) {
        return new MultiDbAsyncPubSubConnectionBuilder<K, V>(this, this.getResources(), codec, this.closeableResources, this.multiDbOptions);
    }

    @Override
    protected DefaultEndpoint createEndpoint() {
        return new DatabaseEndpointImpl(this.getOptions(), this.getResources());
    }

    @Override
    protected <K, V> PubSubEndpoint<K, V> createPubSubEndpoint() {
        return new DatabasePubSubEndpointImpl(this.getOptions(), this.getResources());
    }
}

