/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.api.BaseRedisClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.api.DatabaseConfig;
import io.lettuce.core.failover.api.MultiDbConnectionFuture;
import io.lettuce.core.failover.api.MultiDbOptions;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.api.StatefulRedisMultiDbPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;

@Experimental
public interface MultiDbClient
extends BaseRedisClient {
    public static MultiDbClient create(Collection<DatabaseConfig> databaseConfigs) {
        return new MultiDbClientImpl(databaseConfigs, MultiDbOptions.create());
    }

    public static MultiDbClient create(ClientResources resources, Collection<DatabaseConfig> databaseConfigs) {
        return new MultiDbClientImpl(resources, databaseConfigs, MultiDbOptions.create());
    }

    public static MultiDbClient create(Collection<DatabaseConfig> databaseConfigs, MultiDbOptions multiDbOptions) {
        return new MultiDbClientImpl(databaseConfigs, multiDbOptions);
    }

    public static MultiDbClient create(ClientResources resources, Collection<DatabaseConfig> databaseConfigs, MultiDbOptions multiDbOptions) {
        return new MultiDbClientImpl(resources, databaseConfigs, multiDbOptions);
    }

    public Collection<RedisURI> getRedisURIs();

    public <K, V> StatefulRedisMultiDbConnection<K, V> connect(RedisCodec<K, V> var1);

    public StatefulRedisMultiDbConnection<String, String> connect();

    public <K, V> StatefulRedisMultiDbPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> var1);

    public StatefulRedisMultiDbPubSubConnection<String, String> connectPubSub();

    public <K, V> MultiDbConnectionFuture<StatefulRedisMultiDbConnection<K, V>> connectAsync(RedisCodec<K, V> var1);

    public MultiDbConnectionFuture<StatefulRedisMultiDbConnection<String, String>> connectAsync();

    public <K, V> MultiDbConnectionFuture<StatefulRedisMultiDbPubSubConnection<K, V>> connectPubSubAsync(RedisCodec<K, V> var1);

    public MultiDbConnectionFuture<StatefulRedisMultiDbPubSubConnection<String, String>> connectPubSubAsync();

    public MultiDbOptions getMultiDbOptions();
}

