/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.AbstractRedisMultiDbConnectionBuilder;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.RedisDatabaseDeferredCompletion;
import io.lettuce.core.failover.RedisDatabaseImpl;
import io.lettuce.core.failover.StatefulRedisMultiDbPubSubConnectionImpl;
import io.lettuce.core.failover.api.MultiDbOptions;
import io.lettuce.core.failover.api.StatefulRedisMultiDbPubSubConnection;
import io.lettuce.core.failover.health.HealthStatusManager;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;

class MultiDbAsyncPubSubConnectionBuilder<K, V>
extends AbstractRedisMultiDbConnectionBuilder<StatefulRedisMultiDbPubSubConnection<K, V>, StatefulRedisPubSubConnection<K, V>, K, V> {
    private final Collection<Closeable> closeableResources;

    MultiDbAsyncPubSubConnectionBuilder(MultiDbClientImpl client, ClientResources resources, RedisCodec<K, V> codec, Collection<Closeable> closeableResources, MultiDbOptions multiDbOptions) {
        super(client, resources, codec, multiDbOptions);
        this.closeableResources = closeableResources;
    }

    @Override
    protected ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectAsync(RedisCodec<K, V> codec, RedisURI uri) {
        return this.client.connectPubSubAsync(codec, uri);
    }

    @Override
    protected StatefulRedisMultiDbPubSubConnection<K, V> createMultiDbConnection(RedisDatabaseImpl<StatefulRedisPubSubConnection<K, V>> selected, Map<RedisURI, RedisDatabaseImpl<StatefulRedisPubSubConnection<K, V>>> databases, RedisCodec<K, V> codec, HealthStatusManager healthStatusManager, RedisDatabaseDeferredCompletion<StatefulRedisPubSubConnection<K, V>> completion, MultiDbOptions multiDbOptions) {
        StatefulRedisMultiDbPubSubConnectionImpl<K, V> connection = new StatefulRedisMultiDbPubSubConnectionImpl<K, V>(selected, databases, this.resources, codec, this::createRedisDatabaseAsync, healthStatusManager, completion, multiDbOptions);
        connection.registerAsCloseable(this.closeableResources);
        return connection;
    }
}

