/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.AbstractRedisMultiDbConnectionBuilder;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.RedisDatabaseDeferredCompletion;
import io.lettuce.core.failover.RedisDatabaseImpl;
import io.lettuce.core.failover.StatefulRedisMultiDbConnectionImpl;
import io.lettuce.core.failover.api.MultiDbOptions;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.health.HealthStatusManager;
import io.lettuce.core.resource.ClientResources;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;

class MultiDbAsyncConnectionBuilder<K, V>
extends AbstractRedisMultiDbConnectionBuilder<StatefulRedisMultiDbConnection<K, V>, StatefulRedisConnection<K, V>, K, V> {
    private final Collection<Closeable> closeableResources;

    MultiDbAsyncConnectionBuilder(MultiDbClientImpl client, ClientResources resources, RedisCodec<K, V> codec, Collection<Closeable> closeableResources, MultiDbOptions multiDbOptions) {
        super(client, resources, codec, multiDbOptions);
        this.closeableResources = closeableResources;
    }

    @Override
    protected ConnectionFuture<StatefulRedisConnection<K, V>> connectAsync(RedisCodec<K, V> codec, RedisURI uri) {
        return this.client.connectAsync(codec, uri);
    }

    @Override
    protected StatefulRedisMultiDbConnection<K, V> createMultiDbConnection(RedisDatabaseImpl<StatefulRedisConnection<K, V>> selected, Map<RedisURI, RedisDatabaseImpl<StatefulRedisConnection<K, V>>> databases, RedisCodec<K, V> codec, HealthStatusManager healthStatusManager, RedisDatabaseDeferredCompletion<StatefulRedisConnection<K, V>> completion, MultiDbOptions multiDbOptions) {
        StatefulRedisMultiDbConnectionImpl<StatefulRedisConnection<K, V>, K, V> connection = new StatefulRedisMultiDbConnectionImpl<StatefulRedisConnection<K, V>, K, V>(selected, databases, this.resources, codec, this::createRedisDatabaseAsync, healthStatusManager, completion, multiDbOptions);
        connection.registerAsCloseable(this.closeableResources);
        return connection;
    }
}

