/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.DatabaseCommandTracker;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;

class DatabasePubSubEndpointImpl<K, V>
extends PubSubEndpoint<K, V>
implements DatabaseEndpoint,
DatabaseCommandTracker.CommandWriter {
    private final DatabaseCommandTracker tracker = new DatabaseCommandTracker(this);
    private CircuitBreaker circuitBreaker;

    public DatabasePubSubEndpointImpl(ClientOptions clientOptions, ClientResources clientResources) {
        super(clientOptions, clientResources);
    }

    @Override
    public void bind(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        this.tracker.bind(circuitBreaker);
    }

    @Override
    public void notifyChannelActive(Channel channel) {
        super.notifyChannelActive(channel);
        this.tracker.setChannel(channel);
    }

    @Override
    public void notifyChannelInactive(Channel channel) {
        super.notifyChannelInactive(channel);
        this.tracker.resetChannel(channel);
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public <K1, V1, T> RedisCommand<K1, V1, T> write(RedisCommand<K1, V1, T> command) {
        return this.tracker.write(command);
    }

    @Override
    public <K1, V1> Collection<RedisCommand<K1, V1, ?>> write(Collection<? extends RedisCommand<K1, V1, ?>> commands) {
        return this.tracker.write(commands);
    }

    @Override
    public List<RedisCommand<?, ?, ?>> drainCommands() {
        return super.drainCommands();
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> writeOne(RedisCommand<K, V, T> command) {
        return super.write(command);
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> writeMany(Collection<? extends RedisCommand<K, V, ?>> commands) {
        return super.write(commands);
    }
}

