/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisException;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Collection;

interface DatabaseEndpoint {
    public void bind(CircuitBreaker var1);

    public Collection<RedisCommand<?, ?, ?>> drainCommands();

    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> var1);

    default public void handOverCommandQueue(DatabaseEndpoint target) {
        Collection<RedisCommand<?, ?, ?>> commands = this.drainCommands();
        for (RedisCommand<?, ?, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                target.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }
}

