/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.CircuitBreakerGeneration;
import io.lettuce.core.failover.MultiDbOutboundHandler;
import io.lettuce.core.failover.api.RedisCircuitBreakerException;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseCommandTracker {
    private static final Logger log = LoggerFactory.getLogger(DatabaseCommandTracker.class);
    private final CommandWriter commandWriter;
    private CircuitBreaker circuitBreaker;
    private AtomicReference<Channel> channelRef = new AtomicReference();

    public DatabaseCommandTracker(CommandWriter commandWriter) {
        this.commandWriter = commandWriter;
    }

    public void bind(CircuitBreaker cb) {
        this.circuitBreaker = cb;
        this.registerHandlerToPipeline();
    }

    private void registerHandlerToPipeline() {
        try {
            Channel targetChannel = this.channelRef.get();
            if (targetChannel == null || this.circuitBreaker == null) {
                return;
            }
            if (this.channelRef.compareAndSet(targetChannel, null)) {
                String commandHandlerName = targetChannel.pipeline().context(CommandHandler.class).name();
                targetChannel.pipeline().addAfter(commandHandlerName, MultiDbOutboundHandler.HANDLER_NAME, (ChannelHandler)new MultiDbOutboundHandler(this.circuitBreaker));
            }
        }
        catch (Exception e) {
            log.error("Failed to register MultiDbOutboundHandler to pipeline", (Throwable)e);
            throw e;
        }
    }

    public void setChannel(Channel channel) {
        this.channelRef.set(channel);
        this.registerHandlerToPipeline();
    }

    public void resetChannel(Channel channel) {
        if (channel.pipeline().get(MultiDbOutboundHandler.class) != null) {
            channel.pipeline().remove(MultiDbOutboundHandler.class);
        }
    }

    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, T> result;
        if (this.circuitBreaker == null) {
            return this.commandWriter.writeOne(command);
        }
        if (!this.circuitBreaker.isClosed()) {
            command.completeExceptionally(RedisCircuitBreakerException.INSTANCE);
            return command;
        }
        try {
            result = this.commandWriter.writeOne(command);
        }
        catch (Exception e) {
            this.circuitBreaker.getGeneration().recordResult(e);
            throw e;
        }
        CircuitBreakerGeneration generation = this.circuitBreaker.getGeneration();
        this.attachRecorder(generation, result);
        return result;
    }

    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        Collection<RedisCommand<K, V, ?>> result;
        if (this.circuitBreaker == null) {
            return this.commandWriter.writeMany(commands);
        }
        if (!this.circuitBreaker.isClosed()) {
            commands.forEach(c -> c.completeExceptionally(RedisCircuitBreakerException.INSTANCE));
            return commands;
        }
        try {
            result = this.commandWriter.writeMany(commands);
        }
        catch (Exception e) {
            this.circuitBreaker.getGeneration().recordResult(e);
            throw e;
        }
        CircuitBreakerGeneration generation = this.circuitBreaker.getGeneration();
        for (RedisCommand<K, V, ?> command : result) {
            this.attachRecorder(generation, command);
        }
        return result;
    }

    private <K, V> void attachRecorder(CircuitBreakerGeneration generation, RedisCommand<K, V, ?> command) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete((o, e) -> {
                if (e instanceof RedisCommandTimeoutException) {
                    generation.recordResult((Throwable)e);
                }
            });
        }
    }

    static interface CommandWriter {
        public <K, V, T> RedisCommand<K, V, T> writeOne(RedisCommand<K, V, T> var1);

        public <K, V> Collection<RedisCommand<K, V, ?>> writeMany(Collection<? extends RedisCommand<K, V, ?>> var1);
    }
}

