/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisURI;
import io.lettuce.core.failover.AbstractRedisMultiDbConnectionBuilder;
import io.lettuce.core.failover.api.InitializationPolicy;
import io.lettuce.core.failover.health.HealthStatus;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

class ConnectionInitializationContext
implements InitializationPolicy.InitializationContext {
    private int available = 0;
    private int failed = 0;
    private int pending = 0;

    public ConnectionInitializationContext(AbstractRedisMultiDbConnectionBuilder.DatabaseFutureMap<?> databaseFutures, Map<RedisURI, CompletableFuture<HealthStatus>> healthStatuses) {
        for (Map.Entry entry : databaseFutures.entrySet()) {
            RedisURI endpoint = (RedisURI)entry.getKey();
            CompletableFuture dbFuture = (CompletableFuture)entry.getValue();
            if (dbFuture.isDone()) {
                if (dbFuture.isCompletedExceptionally()) {
                    ++this.failed;
                    continue;
                }
                CompletableFuture<HealthStatus> statusFuture = healthStatuses.get(endpoint);
                if (statusFuture.isDone()) {
                    if (!statusFuture.isCompletedExceptionally() && statusFuture.getNow(null) == HealthStatus.HEALTHY) {
                        ++this.available;
                        continue;
                    }
                    ++this.failed;
                    continue;
                }
                ++this.pending;
                continue;
            }
            ++this.pending;
        }
    }

    @Override
    public int getAvailableConnections() {
        return this.available;
    }

    @Override
    public int getFailedConnections() {
        return this.failed;
    }

    @Override
    public int getPendingConnections() {
        return this.pending;
    }

    public InitializationPolicy.Decision conformsTo(InitializationPolicy policy) {
        return policy.evaluate(this);
    }

    public String toString() {
        return "ConnectionInitializationContext{available=" + this.available + ", failed=" + this.failed + ", pending=" + this.pending + '}';
    }
}

