/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.CircuitBreakerGeneration;
import io.lettuce.core.failover.api.CircuitBreakerConfig;
import io.lettuce.core.failover.api.CircuitBreakerStateChangeEvent;
import io.lettuce.core.failover.api.CircuitBreakerStateListener;
import io.lettuce.core.failover.metrics.CircuitBreakerMetrics;
import io.lettuce.core.failover.metrics.MetricsFactory;
import io.lettuce.core.failover.metrics.MetricsSnapshot;
import io.lettuce.core.internal.LettuceAssert;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CircuitBreakerImpl
implements CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(CircuitBreaker.class);
    private final CircuitBreakerConfig config;
    private final AtomicReference<CircuitBreakerStateHolder> stateRef;
    private final Set<CircuitBreakerStateListener> listeners = ConcurrentHashMap.newKeySet();
    private final Set<Class<? extends Throwable>> trackedExceptions;
    private final String id;

    public CircuitBreakerImpl(CircuitBreakerConfig config) {
        LettuceAssert.notNull((Object)config, "CircuitBreakerConfig must not be null");
        this.id = Integer.toString(this.hashCode());
        this.config = config;
        this.trackedExceptions = new HashSet<Class<? extends Throwable>>(config.getTrackedExceptions());
        this.stateRef = new AtomicReference<CircuitBreakerStateHolder>(new CircuitBreakerStateHolder(this, MetricsFactory.createDefaultMetrics(config.getMetricsWindowSize()), CircuitBreaker.State.CLOSED));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MetricsSnapshot getSnapshot() {
        return this.stateRef.get().metrics.getSnapshot();
    }

    @Override
    public CircuitBreakerGeneration getGeneration() {
        return this.stateRef.get();
    }

    public String toString() {
        CircuitBreakerStateHolder current = this.stateRef.get();
        return "CircuitBreaker{state=" + (Object)((Object)current.state) + ", metrics=" + current.metrics + ", config=" + this.config + '}';
    }

    boolean isCircuitBreakerTrackedException(Throwable throwable) {
        Class<?> errorClass = throwable.getClass();
        for (Class<? extends Throwable> trackedException : this.trackedExceptions) {
            if (!trackedException.isAssignableFrom(errorClass)) continue;
            return true;
        }
        return false;
    }

    void recordResult(CircuitBreakerStateHolder generation, Throwable error) {
        if (error != null && this.isCircuitBreakerTrackedException(error)) {
            this.recordFailure(generation);
        } else {
            this.recordSuccess(generation);
        }
    }

    void recordFailure(CircuitBreakerStateHolder state) {
        state.metrics.recordFailure();
        this.evaluateMetrics(state);
    }

    void recordSuccess(CircuitBreakerStateHolder state) {
        state.metrics.recordSuccess();
    }

    MetricsSnapshot evaluateMetrics() {
        return this.evaluateMetrics(this.stateRef.get());
    }

    MetricsSnapshot evaluateMetrics(CircuitBreakerStateHolder current) {
        boolean evaluationResult;
        MetricsSnapshot snapshot = current.metrics.getSnapshot();
        boolean bl = evaluationResult = snapshot.getFailureRate() >= (double)this.config.getFailureRateThreshold() && snapshot.getFailureCount() >= (long)this.config.getMinimumNumberOfFailures();
        if (evaluationResult) {
            this.stateTransitionTo(CircuitBreaker.State.OPEN);
        }
        return snapshot;
    }

    @Override
    public void transitionTo(CircuitBreaker.State newState) {
        this.stateTransitionTo(newState);
    }

    private void stateTransitionTo(CircuitBreaker.State newState) {
        CircuitBreakerMetrics nextMetrics;
        CircuitBreakerStateHolder next;
        CircuitBreakerStateHolder current;
        do {
            current = this.stateRef.get();
            if (current.state != newState) continue;
            return;
        } while (!this.stateRef.compareAndSet(current, next = new CircuitBreakerStateHolder(this, nextMetrics = MetricsFactory.createDefaultMetrics(this.config.getMetricsWindowSize()), newState)));
        if (log.isInfoEnabled()) {
            log.info("Circuit breaker for {} transitioned from {} to {}", new Object[]{this.id, current.state, newState});
        }
        this.fireStateChanged(current.state, newState);
    }

    @Override
    public CircuitBreaker.State getCurrentState() {
        return this.stateRef.get().state;
    }

    @Override
    public boolean isClosed() {
        return this.getCurrentState().isClosed();
    }

    @Override
    public void addListener(CircuitBreakerStateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CircuitBreakerStateListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStateChanged(CircuitBreaker.State previousState, CircuitBreaker.State newState) {
        CircuitBreakerStateChangeEvent event = new CircuitBreakerStateChangeEvent(this, previousState, newState);
        for (CircuitBreakerStateListener listener : this.listeners) {
            try {
                listener.onCircuitBreakerStateChange(event);
            }
            catch (Exception e) {
                log.error("Error notifying listener " + listener + " of state change " + event, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
    }

    private static final class CircuitBreakerStateHolder
    implements CircuitBreakerGeneration {
        final CircuitBreaker.State state;
        final CircuitBreakerMetrics metrics;
        final CircuitBreakerImpl circuitBreaker;

        CircuitBreakerStateHolder(CircuitBreakerImpl circuitBreaker, CircuitBreakerMetrics metrics, CircuitBreaker.State state) {
            this.state = state;
            this.metrics = metrics;
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public void recordResult(Throwable error) {
            CircuitBreakerGeneration current = this.circuitBreaker.getGeneration();
            if (current != this) {
                return;
            }
            this.circuitBreaker.recordResult(this, error);
        }
    }
}

