/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.Delegating;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.CircuitBreakerImpl;
import io.lettuce.core.failover.ConnectionInitializationContext;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.RawConnectionFactoryImpl;
import io.lettuce.core.failover.RedisDatabaseDeferredCompletion;
import io.lettuce.core.failover.RedisDatabaseImpl;
import io.lettuce.core.failover.StatusTracker;
import io.lettuce.core.failover.api.BaseRedisMultiDbConnection;
import io.lettuce.core.failover.api.DatabaseConfig;
import io.lettuce.core.failover.api.InitializationPolicy;
import io.lettuce.core.failover.api.MultiDbOptions;
import io.lettuce.core.failover.health.HealthCheck;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthCheckStrategySupplier;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.HealthStatusManager;
import io.lettuce.core.failover.health.HealthStatusManagerImpl;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

abstract class AbstractRedisMultiDbConnectionBuilder<MC extends BaseRedisMultiDbConnection, SC extends StatefulRedisConnection<K, V>, K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractRedisMultiDbConnectionBuilder.class);
    protected final MultiDbClientImpl client;
    protected final ClientResources resources;
    protected final RedisCodec<K, V> codec;
    protected final MultiDbOptions multiDbOptions;
    protected final InitializationPolicy initializationPolicy;

    AbstractRedisMultiDbConnectionBuilder(MultiDbClientImpl client, ClientResources resources, RedisCodec<K, V> codec, MultiDbOptions multiDbOptions) {
        this.resources = resources;
        this.client = client;
        this.codec = codec;
        this.multiDbOptions = multiDbOptions;
        this.initializationPolicy = multiDbOptions.getInitializationPolicy();
    }

    protected abstract ConnectionFuture<SC> connectAsync(RedisCodec<K, V> var1, RedisURI var2);

    protected abstract MC createMultiDbConnection(RedisDatabaseImpl<SC> var1, Map<RedisURI, RedisDatabaseImpl<SC>> var2, RedisCodec<K, V> var3, HealthStatusManager var4, RedisDatabaseDeferredCompletion<SC> var5, MultiDbOptions var6);

    CompletableFuture<MC> connectAsync(Map<RedisURI, DatabaseConfig> databaseConfigs) {
        HealthStatusManager healthStatusManager = this.createHealthStatusManager();
        DatabaseMap databases = new DatabaseMap(databaseConfigs.size());
        DatabaseFutureMap databaseFutures = this.createDatabaseFutures(databaseConfigs, databases, healthStatusManager);
        Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures = this.createHealthStatusFutures(databaseFutures, healthStatusManager);
        CompletableFuture<MC> connectionFuture = this.buildConnectionFuture(databaseConfigs, healthStatusManager, databases, databaseFutures, healthStatusFutures);
        return connectionFuture;
    }

    CompletableFuture<MC> buildConnectionFuture(Map<RedisURI, DatabaseConfig> databaseConfigs, HealthStatusManager healthStatusManager, DatabaseMap<SC> databases, DatabaseFutureMap<SC> databaseFutures, Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures) {
        CompletableFuture connectionFuture = new CompletableFuture();
        List sortedConfigs = databaseConfigs.values().stream().sorted(Comparator.comparingDouble(DatabaseConfig::getWeight).reversed()).collect(Collectors.toList());
        AtomicReference initialDb = new AtomicReference();
        for (CompletableFuture<HealthStatus> healthStatusFuture : healthStatusFutures.values()) {
            healthStatusFuture.handleAsync((healthStatus, throwable) -> this.handleHealthStatusResults(healthStatusManager, databases, databaseFutures, healthStatusFutures, connectionFuture, sortedConfigs, initialDb));
        }
        connectionFuture.whenComplete((conn, throwable) -> {
            if (throwable != null) {
                this.destroyBuilderResources(databaseFutures, healthStatusFutures, healthStatusManager);
            }
        });
        return connectionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Void handleHealthStatusResults(HealthStatusManager healthStatusManager, DatabaseMap<SC> databases, DatabaseFutureMap<SC> databaseFutures, Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures, CompletableFuture<MC> connectionFuture, List<DatabaseConfig> sortedConfigs, AtomicReference<RedisDatabaseImpl<SC>> initialDb) {
        Object conn = null;
        Exception capturedFailure = null;
        RedisDatabaseImpl<SC> candidate = null;
        try {
            candidate = this.findInitialDbCandidate(sortedConfigs, databaseFutures, healthStatusFutures);
        }
        catch (Exception e) {
            logger.error("Error while finding initial db candidate", (Throwable)e);
            connectionFuture.completeExceptionally(new RedisConnectionException("Error while finding initial db candidate", e));
        }
        try {
            ConnectionInitializationContext ctx = new ConnectionInitializationContext(databaseFutures, healthStatusFutures);
            InitializationPolicy.Decision decision = ctx.conformsTo(this.initializationPolicy);
            logger.info("Initialization policy decision: {} with context: {}", (Object)decision, (Object)ctx);
            if (decision == InitializationPolicy.Decision.CONTINUE) {
                candidate = null;
            }
            if (decision == InitializationPolicy.Decision.FAIL) {
                if (this.checkIfAllFailed(healthStatusFutures)) {
                    connectionFuture.completeExceptionally(new RedisConnectionException("No healthy database available!"));
                } else {
                    connectionFuture.completeExceptionally(new RedisConnectionException("Initialization failed due to initialization policy: " + ctx));
                }
                Void void_ = null;
                return void_;
            }
            if (candidate != null && initialDb.compareAndSet(null, candidate)) {
                logger.info("Selected {} as primary database", candidate);
                conn = this.buildConn(healthStatusManager, databases, databaseFutures, candidate);
                connectionFuture.complete(conn);
            }
        }
        catch (Exception e) {
            logger.error("Error while building connection", (Throwable)e);
            capturedFailure = e;
        }
        finally {
            if (conn == null && this.checkIfAllFailed(healthStatusFutures)) {
                connectionFuture.completeExceptionally(new RedisConnectionException("No healthy database available!", capturedFailure));
            }
        }
        return null;
    }

    void destroyBuilderResources(DatabaseFutureMap<SC> databaseFutures, Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures, HealthStatusManager healthStatusManager) {
        databaseFutures.values().forEach(dbf -> dbf.whenComplete((db, ex) -> {
            if (db != null) {
                db.closeAsync();
            }
        }));
        healthStatusFutures.values().forEach(f -> f.cancel(false));
        try {
            healthStatusManager.close();
        }
        catch (Exception e) {
            logger.error("Error while closing health status manager", (Throwable)e);
        }
    }

    MC buildConn(HealthStatusManager healthStatusManager, DatabaseMap<SC> databases, DatabaseFutureMap<SC> databaseFutures, RedisDatabaseImpl<SC> selected) {
        DatabaseMap clone = new DatabaseMap(databases);
        List remainingDbFutures = databaseFutures.entrySet().stream().filter(entry -> !clone.containsKey(entry.getKey())).map(entry -> (CompletableFuture)entry.getValue()).collect(Collectors.toList());
        RedisDatabaseDeferredCompletion completion = new RedisDatabaseDeferredCompletion(remainingDbFutures);
        return this.createMultiDbConnection(selected, clone, this.codec, healthStatusManager, completion, this.multiDbOptions);
    }

    DatabaseFutureMap<SC> createDatabaseFutures(Map<RedisURI, DatabaseConfig> databaseConfigs, DatabaseMap<SC> databases, HealthStatusManager healthStatusManager) {
        DatabaseFutureMap databaseFutures = new DatabaseFutureMap(databaseConfigs.size());
        for (Map.Entry<RedisURI, DatabaseConfig> entry : databaseConfigs.entrySet()) {
            RedisURI uri = entry.getKey();
            DatabaseConfig config = entry.getValue();
            databaseFutures.put(uri, this.createRedisDatabaseAsync(config, healthStatusManager).thenApply(db -> {
                databases.put(uri, db);
                return db;
            }));
        }
        return databaseFutures;
    }

    CompletableFuture<RedisDatabaseImpl<SC>> createRedisDatabaseAsync(DatabaseConfig config, HealthStatusManager healthStatusManager) {
        RedisURI uri = config.getRedisURI();
        this.client.setOptions(config.getClientOptions());
        try {
            ConnectionFuture<SC> connectionFuture = this.connectAsync(this.codec, uri);
            this.client.resetOptions();
            return ((CompletableFuture)connectionFuture.toCompletableFuture().thenApply(connection -> {
                try {
                    HealthCheck healthCheck = null;
                    if (HealthCheckStrategySupplier.NO_HEALTH_CHECK != config.getHealthCheckStrategySupplier()) {
                        HealthCheckStrategy hcStrategy = config.getHealthCheckStrategySupplier().get(config.getRedisURI(), new RawConnectionFactoryImpl(config.getClientOptions(), this.client));
                        healthCheck = healthStatusManager.add(uri, hcStrategy);
                    }
                    DatabaseEndpoint databaseEndpoint = this.extractDatabaseEndpoint((StatefulRedisConnection<?, ?>)connection);
                    CircuitBreakerImpl circuitBreaker = new CircuitBreakerImpl(config.getCircuitBreakerConfig());
                    databaseEndpoint.bind(circuitBreaker);
                    RedisDatabaseImpl<StatefulRedisConnection> database = new RedisDatabaseImpl<StatefulRedisConnection>(config, (StatefulRedisConnection)connection, databaseEndpoint, circuitBreaker, healthCheck);
                    if (logger.isInfoEnabled()) {
                        logger.info("Created database: {} with CircuitBreaker {} and HealthCheck {}", new Object[]{database.getId(), circuitBreaker.getId(), healthCheck != null ? healthCheck.getEndpoint() : "N/A"});
                    }
                    return database;
                }
                catch (Exception e) {
                    connection.closeAsync();
                    throw e;
                }
            })).exceptionally(throwable -> {
                logger.error("Failed to create database connection for {}: {}", new Object[]{uri, throwable.getMessage(), throwable});
                throw new CompletionException((Throwable)throwable);
            });
        }
        catch (Exception e) {
            this.client.resetOptions();
            logger.error("Failed to initiate database connection for {}: {}", new Object[]{uri, e.getMessage(), e});
            CompletableFuture<RedisDatabaseImpl<SC>> failedFuture = new CompletableFuture<RedisDatabaseImpl<SC>>();
            failedFuture.completeExceptionally(e);
            return failedFuture;
        }
    }

    Map<RedisURI, CompletableFuture<HealthStatus>> createHealthStatusFutures(DatabaseFutureMap<SC> databaseFutures, HealthStatusManager healthStatusManager) {
        StatusTracker statusTracker = new StatusTracker(healthStatusManager, this.resources);
        HashMap<RedisURI, CompletableFuture<HealthStatus>> healthCheckFutures = new HashMap<RedisURI, CompletableFuture<HealthStatus>>();
        for (Map.Entry entry : databaseFutures.entrySet()) {
            RedisURI endpoint = (RedisURI)entry.getKey();
            CompletableFuture dbFuture = (CompletableFuture)entry.getValue();
            CompletionStage healthCheckFuture = dbFuture.thenCompose(database -> {
                if (database.getHealthCheck() != null) {
                    logger.info("Health checks enabled for {}, waiting for result", (Object)endpoint);
                    return statusTracker.waitForHealthStatusAsync(endpoint);
                }
                logger.info("No health check configured for database {}, defaulting to HEALTHY", (Object)endpoint);
                return CompletableFuture.completedFuture(HealthStatus.HEALTHY);
            });
            healthCheckFutures.put(endpoint, (CompletableFuture<HealthStatus>)healthCheckFuture);
        }
        return healthCheckFutures;
    }

    RedisDatabaseImpl<SC> findInitialDbCandidate(List<DatabaseConfig> sortedConfigs, DatabaseFutureMap<SC> databaseFutures, Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures) {
        for (DatabaseConfig config : sortedConfigs) {
            CompletableFuture dbFuture = (CompletableFuture)databaseFutures.get(config.getRedisURI());
            if (!dbFuture.isDone()) {
                logger.debug("Waiting for database connection to complete for {}", (Object)config.getRedisURI());
                return null;
            }
            if (dbFuture.isCompletedExceptionally()) {
                logger.debug("Skipping failed database connection for {}", (Object)config.getRedisURI());
                continue;
            }
            CompletableFuture<HealthStatus> healthStatusFuture = healthStatusFutures.get(config.getRedisURI());
            if (!healthStatusFuture.isDone()) {
                logger.debug("Waiting for health check to complete for {}", (Object)config.getRedisURI());
                return null;
            }
            if (healthStatusFuture.isCompletedExceptionally()) {
                logger.debug("Skipping database with failed health check for {}", (Object)config.getRedisURI());
                continue;
            }
            HealthStatus healthStatus = healthStatusFuture.getNow(HealthStatus.UNKNOWN);
            if (healthStatus.isHealthy()) {
                return dbFuture.getNow(null);
            }
            logger.debug("Database {} is not healthy, skipping", (Object)config.getRedisURI());
        }
        return null;
    }

    boolean checkIfAllFailed(Map<RedisURI, CompletableFuture<HealthStatus>> healthStatusFutures) {
        boolean noneHealthy;
        boolean allHealthChecksCompleted = healthStatusFutures.values().stream().allMatch(CompletableFuture::isDone);
        return allHealthChecksCompleted && (noneHealthy = healthStatusFutures.values().stream().filter(singleFuture -> !singleFuture.isCompletedExceptionally()).map(singleFuture -> singleFuture.getNow(null)).noneMatch(status -> status == HealthStatus.HEALTHY));
    }

    DatabaseEndpoint extractDatabaseEndpoint(StatefulRedisConnection<?, ?> connection) {
        RedisChannelWriter writer = ((StatefulRedisConnectionImpl)connection).getChannelWriter();
        if (writer instanceof Delegating) {
            writer = (RedisChannelWriter)((Delegating)((Object)writer)).unwrap();
        }
        return (DatabaseEndpoint)((Object)writer);
    }

    protected HealthStatusManager createHealthStatusManager() {
        return new HealthStatusManagerImpl();
    }

    static class DatabaseFutureMap<SC extends StatefulRedisConnection<?, ?>>
    extends ConcurrentHashMap<RedisURI, CompletableFuture<RedisDatabaseImpl<SC>>> {
        public DatabaseFutureMap() {
        }

        public DatabaseFutureMap(int initialCapacity) {
            super(initialCapacity);
        }

        public DatabaseFutureMap(Map<RedisURI, CompletableFuture<RedisDatabaseImpl<SC>>> map) {
            super(map);
        }
    }

    static class DatabaseMap<SC extends StatefulRedisConnection<?, ?>>
    extends ConcurrentHashMap<RedisURI, RedisDatabaseImpl<SC>> {
        public DatabaseMap() {
        }

        public DatabaseMap(int initialCapacity) {
            super(initialCapacity);
        }

        public DatabaseMap(Map<RedisURI, RedisDatabaseImpl<SC>> map) {
            super(map);
        }
    }
}

