/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.Objects;

public class XCfgSetArgs
implements CompositeArgument {
    private Long idmpDuration;
    private Long idmpMaxsize;

    public XCfgSetArgs idmpDuration(long duration) {
        LettuceAssert.isTrue(duration >= 1L && duration <= 86400L, "IDMP-DURATION must be between 1 and 86400 seconds");
        this.idmpDuration = duration;
        return this;
    }

    public XCfgSetArgs idmpMaxsize(long maxsize) {
        LettuceAssert.isTrue(maxsize >= 1L && maxsize <= 10000L, "IDMP-MAXSIZE must be between 1 and 10000");
        this.idmpMaxsize = maxsize;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.idmpDuration != null) {
            args.add(CommandKeyword.IDMP_DURATION).add(this.idmpDuration);
        }
        if (this.idmpMaxsize != null) {
            args.add(CommandKeyword.IDMP_MAXSIZE).add(this.idmpMaxsize);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XCfgSetArgs that = (XCfgSetArgs)o;
        return Objects.equals(this.idmpDuration, that.idmpDuration) && Objects.equals(this.idmpMaxsize, that.idmpMaxsize);
    }

    public int hashCode() {
        return Objects.hash(this.idmpDuration, this.idmpMaxsize);
    }

    public static class Builder {
        private Builder() {
        }

        public static XCfgSetArgs idmpDuration(long duration) {
            return new XCfgSetArgs().idmpDuration(duration);
        }

        public static XCfgSetArgs idmpMaxsize(long maxsize) {
            return new XCfgSetArgs().idmpMaxsize(maxsize);
        }
    }
}

