/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.StreamDeletionPolicy;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.nio.charset.StandardCharsets;

public class XAddArgs
implements CompositeArgument {
    private String id;
    private Long maxlen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minid;
    private Long limit;
    private StreamDeletionPolicy trimmingMode;
    private byte[] producerId;
    private byte[] idempotentId;
    private boolean autoIdempotent;

    public XAddArgs id(String id) {
        LettuceAssert.notNull((Object)id, "Id must not be null");
        this.id = id;
        return this;
    }

    public XAddArgs maxlen(long maxlen) {
        LettuceAssert.isTrue(maxlen > 0L, "Maxlen must be greater 0");
        this.maxlen = maxlen;
        return this;
    }

    public XAddArgs minId(String minid) {
        LettuceAssert.notNull((Object)minid, "minId must not be null");
        this.minid = minid;
        return this;
    }

    public XAddArgs limit(long limit) {
        LettuceAssert.isTrue(limit > 0L, "Limit must be greater 0");
        this.limit = limit;
        return this;
    }

    public XAddArgs trimmingMode(StreamDeletionPolicy trimmingMode) {
        this.trimmingMode = trimmingMode;
        return this;
    }

    public XAddArgs approximateTrimming() {
        return this.approximateTrimming(true);
    }

    public XAddArgs approximateTrimming(boolean approximateTrimming) {
        this.approximateTrimming = approximateTrimming;
        return this;
    }

    public XAddArgs exactTrimming() {
        return this.exactTrimming(true);
    }

    public XAddArgs exactTrimming(boolean exactTrimming) {
        this.exactTrimming = exactTrimming;
        return this;
    }

    public XAddArgs nomkstream() {
        return this.nomkstream(true);
    }

    public XAddArgs nomkstream(boolean nomkstream) {
        this.nomkstream = nomkstream;
        return this;
    }

    public XAddArgs idmp(byte[] producerId, byte[] idempotentId) {
        LettuceAssert.notNull((Object)producerId, "Producer ID must not be null");
        LettuceAssert.notNull((Object)idempotentId, "Idempotent ID must not be null");
        LettuceAssert.isTrue(!this.autoIdempotent, "Cannot use both IDMP and IDMPAUTO");
        this.producerId = producerId;
        this.idempotentId = idempotentId;
        return this;
    }

    public XAddArgs idmp(String producerId, String idempotentId) {
        LettuceAssert.notNull((Object)producerId, "Producer ID must not be null");
        LettuceAssert.notNull((Object)idempotentId, "Idempotent ID must not be null");
        return this.idmp(producerId.getBytes(StandardCharsets.UTF_8), idempotentId.getBytes(StandardCharsets.UTF_8));
    }

    public XAddArgs idmpAuto(byte[] producerId) {
        LettuceAssert.notNull((Object)producerId, "Producer ID must not be null");
        LettuceAssert.isTrue(this.idempotentId == null, "Cannot use both IDMP and IDMPAUTO");
        this.producerId = producerId;
        this.autoIdempotent = true;
        return this;
    }

    public XAddArgs idmpAuto(String producerId) {
        LettuceAssert.notNull((Object)producerId, "Producer ID must not be null");
        return this.idmpAuto(producerId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.nomkstream) {
            args.add(CommandKeyword.NOMKSTREAM);
        }
        if (this.trimmingMode != null) {
            args.add(this.trimmingMode);
        }
        if (this.autoIdempotent) {
            args.add(CommandKeyword.IDMPAUTO);
            args.add(this.producerId);
        } else if (this.producerId != null && this.idempotentId != null) {
            args.add(CommandKeyword.IDMP);
            args.add(this.producerId);
            args.add(this.idempotentId);
        }
        if (this.maxlen != null) {
            args.add(CommandKeyword.MAXLEN);
            if (this.approximateTrimming) {
                args.add("~");
            } else if (this.exactTrimming) {
                args.add("=");
            }
            args.add(this.maxlen);
        }
        if (this.minid != null) {
            args.add(CommandKeyword.MINID);
            if (this.approximateTrimming) {
                args.add("~");
            } else if (this.exactTrimming) {
                args.add("=");
            }
            args.add(this.minid);
        }
        if (this.limit != null && this.approximateTrimming) {
            args.add(CommandKeyword.LIMIT).add(this.limit);
        }
        if (this.id != null) {
            args.add(this.id);
        } else {
            args.add("*");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XAddArgs maxlen(long count) {
            return new XAddArgs().maxlen(count);
        }

        public static XAddArgs nomkstream() {
            return new XAddArgs().nomkstream();
        }

        public static XAddArgs minId(String minid) {
            return new XAddArgs().minId(minid);
        }

        public static XAddArgs idmp(byte[] producerId, byte[] idempotentId) {
            return new XAddArgs().idmp(producerId, idempotentId);
        }

        public static XAddArgs idmp(String producerId, String idempotentId) {
            return new XAddArgs().idmp(producerId, idempotentId);
        }

        public static XAddArgs idmpAuto(byte[] producerId) {
            return new XAddArgs().idmpAuto(producerId);
        }

        public static XAddArgs idmpAuto(String producerId) {
            return new XAddArgs().idmpAuto(producerId);
        }
    }
}

